/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula;

import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.vikamine.kernel.formula.ASTBuilder;
import org.vikamine.kernel.formula.ParserElement;
import org.vikamine.kernel.formula.exception.ASTBuildingException;
import org.vikamine.kernel.formula.exception.MissingClosingBraceException;
import org.vikamine.kernel.formula.exception.MissingOpeningBraceException;
import org.vikamine.kernel.formula.exception.MissingOperandException;
import org.vikamine.kernel.formula.exception.MissingOperatorException;

public class DefaultASTBuilder
implements ASTBuilder {
    protected boolean braceOpened;
    protected Stack operandStack = new Stack();
    protected Stack operatorStack = new Stack();

    public DefaultASTBuilder() {
    }

    public DefaultASTBuilder(boolean braceOpened) {
        this.braceOpened = braceOpened;
    }

    protected ParserElement buildAST(Iterator iter) throws EmptyStackException, MissingClosingBraceException, MissingOpeningBraceException {
        boolean closed = false;
        while (iter.hasNext() && !closed) {
            ParserElement pe = (ParserElement)iter.next();
            if (pe.isOpeningBrace()) {
                this.operandStack.push(new DefaultASTBuilder(true).buildAST(iter));
                continue;
            }
            if (pe.isClosingBrace()) {
                closed = true;
                continue;
            }
            if (pe.getRequiredArgumentsCount() > 0) {
                while (this.lowerPrecedence(pe)) {
                    this.reduce();
                }
                this.operatorStack.push(pe);
                continue;
            }
            this.operandStack.push(pe);
        }
        while (!this.operatorStack.isEmpty()) {
            this.reduce();
        }
        if (this.braceOpened && !closed) {
            throw new MissingClosingBraceException("missing closing brace", this.operandStack, this.operatorStack);
        }
        if (!this.braceOpened && closed) {
            throw new MissingOpeningBraceException("missing openingBrace", this.operandStack, this.operatorStack);
        }
        return (ParserElement)this.operandStack.pop();
    }

    @Override
    public ParserElement buildAST(List parserElements) throws ASTBuildingException {
        this.initialize();
        try {
            Iterator iter = parserElements.iterator();
            ParserElement ast = this.buildAST(iter);
            if (!this.operandStack.isEmpty()) {
                this.operandStack.push(ast);
                throw new MissingOperatorException("missing operator", this.operandStack, this.operatorStack);
            }
            return ast;
        }
        catch (EmptyStackException e) {
            throw new MissingOperandException("missing operands", this.operandStack, this.operatorStack);
        }
    }

    protected void initialize() {
        this.operandStack = new Stack();
        this.operatorStack = new Stack();
        this.braceOpened = false;
    }

    public boolean isBraceOpened() {
        return this.braceOpened;
    }

    protected boolean lowerPrecedence(ParserElement pe) {
        if (this.operatorStack.isEmpty()) {
            return false;
        }
        ParserElement stack = (ParserElement)this.operatorStack.peek();
        return stack.getPrecedence() >= pe.getPrecedence();
    }

    protected void reduce() {
        ParserElement op = (ParserElement)this.operatorStack.peek();
        LinkedList children = new LinkedList();
        op.setChildren(children);
        children.add(this.operandStack.pop());
        if (op.getRequiredArgumentsCount() > 1) {
            children.add(0, this.operandStack.pop());
        }
        this.operatorStack.pop();
        this.operandStack.push(op);
    }

    public void setBraceOpened(boolean braceOpened) {
        this.braceOpened = braceOpened;
    }
}

