/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.vikamine.kernel.Describable;
import org.vikamine.kernel.Describer;
import org.vikamine.kernel.KernelResources;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.selectors.BooleanTargetAdapterSelector;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.NegatedSGSelector;
import org.vikamine.kernel.subgroup.selectors.NumericSelector;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.util.IdentityLongDescriber;

public class SGDescription
implements Cloneable,
Describable,
Iterable<SGSelector> {
    private volatile int cachedHashCode;
    protected LinkedHashMap<Attribute, SGSelector> sgSelectors;
    private List cachedPlainSelectors = null;

    public SGDescription() {
        this.sgSelectors = new LinkedHashMap(7);
        this.initHashCode();
    }

    public SGDescription(List<SGSelector> selectors) {
        this();
        this.addAll(selectors);
    }

    protected SGDescription(int initialCapacity, float loadFactor) {
        this.sgSelectors = new LinkedHashMap(initialCapacity, loadFactor);
        this.initHashCode();
    }

    protected void initHashCode() {
        this.cachedHashCode = 0;
        this.cachedPlainSelectors = null;
    }

    public SGDescription clone() {
        try {
            SGDescription clonedSGD = (SGDescription)super.clone();
            clonedSGD.sgSelectors = new LinkedHashMap<Attribute, SGSelector>(this.sgSelectors);
            return clonedSGD;
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "clone", e);
            throw new Error("Assertion failure!");
        }
    }

    public SGDescription deepCopy() {
        SGDescription clonedSGD = this.clone();
        clonedSGD.sgSelectors = new LinkedHashMap(7);
        for (SGSelector sgs : this) {
            clonedSGD.add((SGSelector)sgs.clone());
        }
        return clonedSGD;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SGDescription otherSGD = (SGDescription)other;
        LinkedHashMap<Attribute, SGSelector> otherSGSelectorsMap = otherSGD.sgSelectors;
        if (this.sgSelectors != null && otherSGSelectorsMap != null) {
            return this.sgSelectors.equals(otherSGSelectorsMap);
        }
        return super.equals(other);
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.sgSelectors.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean isMatching(DataRecord instanceToTest) {
        if (instanceToTest != null) {
            for (SGSelector select : this.sgSelectors.values()) {
                if (select.isContainedInInstance(instanceToTest)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void addAll(Collection<? extends SGSelector> selectors) {
        for (SGSelector sGSelector : selectors) {
            this.addInternal(sGSelector);
        }
        this.initHashCode();
    }

    protected void addInternal(SGSelector sGSelector) {
        if (sGSelector instanceof SGNominalSelector) {
            if (this.containsAttributeAsSelector(sGSelector.getAttribute())) {
                List negatedValues;
                SGNominalSelector sel = (SGNominalSelector)this.sgSelectors.get(sGSelector.getAttribute());
                if (sel instanceof NegatedSGSelector) {
                    negatedValues = this.createNegatedValues(sel);
                    sel = new StrictlyConjunctiveSGSelector(sel.getAttribute(), new HashSet(negatedValues));
                } else {
                    if (sel instanceof BooleanTargetAdapterSelector) {
                        throw new UnsupportedOperationException();
                    }
                    sel = new StrictlyConjunctiveSGSelector(sel.getAttribute(), sel.getValues());
                }
                this.sgSelectors.put(sGSelector.getAttribute(), sel);
                if (sGSelector instanceof NegatedSGSelector) {
                    negatedValues = this.createNegatedValues((SGNominalSelector)sGSelector);
                    sel.addAll(negatedValues);
                } else {
                    sel.addAll(((SGNominalSelector)sGSelector).getValues());
                }
            } else {
                this.sgSelectors.put(sGSelector.getAttribute(), sGSelector);
            }
        } else if (sGSelector instanceof NumericSelector) {
            if (this.sgSelectors.containsKey(sGSelector.getAttribute())) {
                NumericSelector oldSel = (NumericSelector)this.sgSelectors.get(sGSelector.getAttribute());
                this.sgSelectors.put(sGSelector.getAttribute(), ((NumericSelector)sGSelector).join(oldSel));
            } else {
                this.sgSelectors.put(sGSelector.getAttribute(), sGSelector);
            }
        } else {
            this.sgSelectors.put(null, sGSelector);
        }
    }

    private List createNegatedValues(SGNominalSelector sGSelector) {
        LinkedList<NegatedValueWrapper> negatedValues = new LinkedList<NegatedValueWrapper>();
        for (Value val : sGSelector.getValues()) {
            NegatedValueWrapper negVal = new NegatedValueWrapper(val);
            negatedValues.add(negVal);
        }
        return negatedValues;
    }

    public void add(SGSelector sGSelector) {
        this.addInternal(sGSelector);
        this.initHashCode();
    }

    public void remove(SGSelector sGSelector) {
        SGSelector sel = this.sgSelectors.get(sGSelector.getAttribute());
        if (sel != null && sel instanceof SGNominalSelector) {
            SGNominalSelector nomSel = (SGNominalSelector)sel;
            if (sel.equals(sGSelector)) {
                this.sgSelectors.remove(sel.getAttribute());
            } else {
                if (sGSelector instanceof NegatedSGSelector) {
                    nomSel.removeAll(this.createNegatedValues((SGNominalSelector)sGSelector));
                } else {
                    nomSel.removeAll(((SGNominalSelector)sGSelector).getValues());
                }
                if (nomSel.getValues().isEmpty()) {
                    this.sgSelectors.remove(sel.getAttribute());
                } else if (nomSel.getValues().size() == 1) {
                    sel = new DefaultSGSelector(sel.getAttribute(), nomSel.getValues());
                    this.sgSelectors.put(sel.getAttribute(), sel);
                }
            }
            this.initHashCode();
        }
    }

    public void removeAll(Collection<SGSelector> selectors) {
        for (SGSelector selector : selectors) {
            this.remove(selector);
        }
    }

    public SGSelector removeSGSelectorForAttribute(Attribute attribute) {
        this.initHashCode();
        return (SGSelector)this.sgSelectors.remove(attribute);
    }

    public boolean containsAttributeAsSelector(Attribute attribute) {
        return this.sgSelectors.containsKey(attribute);
    }

    public String toString() {
        StringBuffer buffy = new StringBuffer();
        buffy.append("S{");
        Iterator<SGSelector> iter = this.sgSelectors.values().iterator();
        while (iter.hasNext()) {
            SGSelector sel = iter.next();
            buffy.append(sel.toString());
            if (!iter.hasNext()) continue;
            buffy.append(", ");
        }
        buffy.append("}");
        return buffy.toString();
    }

    public boolean contains(SGSelector sel) {
        if (this.containsAttributeAsSelector(sel.getAttribute())) {
            if (sel instanceof SGNominalSelector) {
                SGNominalSelector contained = (SGNominalSelector)this.sgSelectors.get(sel.getAttribute());
                if (!(contained instanceof StrictlyConjunctiveSGSelector)) {
                    return contained.equals(sel);
                }
                if (sel instanceof NegatedSGSelector) {
                    List negatedValues = this.createNegatedValues((SGNominalSelector)sel);
                    return contained.getValues().containsAll(negatedValues);
                }
                return contained.getValues().containsAll(((SGNominalSelector)sel).getValues());
            }
            return this.sgSelectors.get(sel.getAttribute()).equals(sel);
        }
        return false;
    }

    public int size() {
        return this.sgSelectors.size();
    }

    public boolean isEmpty() {
        return this.sgSelectors.isEmpty();
    }

    @Override
    public Iterator<SGSelector> iterator() {
        if (this.cachedPlainSelectors == null) {
            ArrayList<SGSelector> selectors = new ArrayList<SGSelector>();
            for (SGSelector sel : this.sgSelectors.values()) {
                if (sel instanceof StrictlyConjunctiveSGSelector) {
                    this.collectSingleSelectors(selectors, (StrictlyConjunctiveSGSelector)sel);
                    continue;
                }
                selectors.add(sel);
            }
            this.cachedPlainSelectors = selectors;
        }
        return this.cachedPlainSelectors.iterator();
    }

    protected void collectSingleSelectors(List selectors, SGNominalSelector sel) {
        for (Value val : sel.getValues()) {
            Cloneable newSel = val instanceof NegatedValueWrapper ? new NegatedSGSelector(new DefaultSGSelector(sel.getAttribute(), ((NegatedValueWrapper)val).getValue())) : new DefaultSGSelector(sel.getAttribute(), val);
            selectors.add(newSel);
        }
    }

    @Override
    public String getId() {
        StringBuffer buffer = new StringBuffer();
        Iterator<SGSelector> sgsIter = this.iterator();
        while (sgsIter.hasNext()) {
            SGNominalSelector sel = (SGNominalSelector)sgsIter.next();
            buffer.append(sel.getId());
            if (!sgsIter.hasNext()) continue;
            buffer.append(" AND ");
        }
        return buffer.toString();
    }

    @Override
    public String getDescription(Describer d) {
        StringBuffer buffer = new StringBuffer();
        Iterator<SGSelector> sgsIter = this.iterator();
        while (sgsIter.hasNext()) {
            SGSelector sel = sgsIter.next();
            buffer.append(d.createDescription(sel));
            if (!sgsIter.hasNext()) continue;
            buffer.append(" " + KernelResources.getInstance().getI18N().getString("vkmKernel.generic.SGSelector.AND").trim() + " ");
        }
        return buffer.toString();
    }

    @Override
    public String getDescription() {
        return this.getDescription(new IdentityLongDescriber());
    }

    public void sortSelectors(Comparator comparator) {
        LinkedList<SGSelector> copy = new LinkedList<SGSelector>(this.sgSelectors.values());
        Collections.sort(copy, comparator);
        this.sgSelectors.clear();
        this.addAll(copy);
    }

    public boolean isSpecialization(SGDescription otherSGDescr) {
        if (this.equals(otherSGDescr)) {
            return false;
        }
        for (Map.Entry<Attribute, SGSelector> entry : otherSGDescr.sgSelectors.entrySet()) {
            Attribute att = entry.getKey();
            SGSelector sel = entry.getValue();
            if (sel.equals(this.sgSelectors.get(att))) continue;
            return false;
        }
        return true;
    }

    public boolean isGeneralization(SGDescription otherSGDescription) {
        return otherSGDescription.isSpecialization(this);
    }

    public List<SGSelector> getSelectors() {
        return new ArrayList<SGSelector>(this.sgSelectors.values());
    }

    private static class NegatedValueWrapper
    extends Value {
        private Value value;

        public NegatedValueWrapper(Value value) {
            super("!" + value.getId());
            this.value = value;
        }

        public Value getValue() {
            return this.value;
        }

        @Override
        public Attribute getAttribute() {
            return this.value.getAttribute();
        }

        @Override
        public String getDescription() {
            return this.getDescription(new IdentityLongDescriber());
        }

        @Override
        public String getDescription(Describer d) {
            return "!" + d.createDescription(this.value);
        }

        public String toString() {
            return "!" + this.value.toString();
        }

        @Override
        public boolean isMissingValue() {
            return this.value.isMissingValue();
        }

        @Override
        public boolean isValueContainedInInstance(DataRecord instance) {
            return !this.value.isValueContainedInInstance(instance);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            return this.value.equals(((NegatedValueWrapper)other).value);
        }

        @Override
        public int computeCachedHashCode() {
            return this.getValue().hashCode();
        }
    }

    private static class StrictlyConjunctiveSGSelector
    extends DefaultSGSelector {
        private StrictlyConjunctiveSGSelector(Attribute a, Set<Value> values) {
            super(a, values);
        }

        @Override
        public boolean isContainedInInstance(DataRecord instance) {
            for (Value value : this.getValues()) {
                if (value.isValueContainedInInstance(instance)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getDescription(Describer d) {
            if (d == null) {
                return this.getDescription();
            }
            StringBuffer buffy = new StringBuffer();
            buffy.append(d.createDescription(this.getAttribute()));
            if (this.getValues().isEmpty() || this.getValues().size() > 1) {
                buffy.append("={");
                LinkedList<Value> sortedValues = new LinkedList<Value>(this.getValues());
                Collections.sort(sortedValues, new Value.ValueComparator());
                Iterator iter = sortedValues.iterator();
                while (iter.hasNext()) {
                    Value element = (Value)iter.next();
                    buffy.append(d.createDescription(element));
                    if (!iter.hasNext()) continue;
                    buffy.append(", ");
                }
                buffy.append("}");
            } else {
                buffy.append("=" + d.createDescription((Value)this.getValues().toArray()[0]));
            }
            return buffy.toString();
        }

        @Override
        public String getDescription() {
            return this.getDescription(new IdentityLongDescriber());
        }

        @Override
        public String getId() {
            StringBuffer buffy = new StringBuffer();
            buffy.append(String.valueOf(this.getAttribute().getId()) + "={");
            LinkedList<Value> sortedValues = new LinkedList<Value>(this.getValues());
            Collections.sort(sortedValues, new Value.ValueComparator());
            Iterator iter = sortedValues.iterator();
            while (iter.hasNext()) {
                Value element = (Value)iter.next();
                buffy.append(element.getId());
                if (!iter.hasNext()) continue;
                buffy.append(", ");
            }
            buffy.append("}");
            return buffy.toString();
        }

        @Override
        public String toString() {
            return this.getId();
        }
    }
}

