/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.SGStatisticsNumeric;
import org.vikamine.kernel.subgroup.quality.AbstractQFStatisticBased;
import org.vikamine.kernel.subgroup.quality.ExtendedNumericStatisticBasedQF;

public class TStatisticsQF
extends AbstractQFStatisticBased
implements ExtendedNumericStatisticBasedQF {
    private static final String ID = "T-Statistics";

    @Override
    public double evaluate(SGStatistics statistics) {
        if (!(statistics instanceof SGStatisticsNumeric)) {
            return Double.NaN;
        }
        SGStatisticsNumeric numStats = (SGStatisticsNumeric)statistics;
        double n = numStats.getSubgroupSize();
        double m = numStats.getSGMean();
        double m_0 = numStats.getPopulationMean();
        double s_0 = numStats.getSgStdDeviation();
        return this.evaluate(n, m, m_0, s_0);
    }

    @Override
    public double evaluate(double n, double m, double m_0, double s_0) {
        return Math.sqrt(n) * (m - m_0) / s_0;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return this.getID();
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return subgroup.getTarget().isNumeric();
    }

    @Override
    public AbstractQFStatisticBased clone() {
        return new TStatisticsQF();
    }
}

