% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cw_phrases.R
\name{cw_phrases}
\alias{cw_phrases}
\title{Capitol words phrases.json method. List the top phrases for a facet.}
\usage{
cw_phrases(entity_type, entity_value, n = NULL, page = NULL,
  per_page = NULL, sort = NULL, as = "table", key = NULL, ...)
}
\arguments{
\item{entity_type}{The entity type to get top phrases for. One of 'date',
'month', 'state', or 'legislator'. Required.}

\item{entity_value}{The value of the entity given in \code{entity_type}.
See Details. Required.}

\item{n}{The size of phrase, in words, to search for (up to 5).}

\item{page}{The page of results to show. 100 results are shown at a time. To get more than
100 results, use the page parameter.}

\item{per_page}{Number of records to return. Default: 20. Max: 50.}

\item{sort}{The value on which to sort the results. You have to specify ascending or
descending (see details), but if you forget, we make it ascending by default
(prevents 500 error :)). Valid values are 'tfidf' (default) and 'count'.}

\item{as}{(character) One of table (default), list, or response (httr response object).}

\item{key}{Your SunlightLabs API key; loads from .Rprofile.}

\item{...}{Further curl options (debugging tools mostly)}
}
\value{
Data frame of observations by date.
}
\description{
Capitol words phrases.json method. List the top phrases for a facet.
}
\examples{
\dontrun{
cw_phrases(entity_type='month', entity_value=201007)
cw_phrases(entity_type='state', entity_value='NV')
cw_phrases(entity_type='legislator', entity_value='L000551')

library('httr')
head(cw_phrases(entity_type='month', entity_value=201007, config=verbose()))
}
}

