% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_statements.R
\name{statements}
\alias{statements}
\alias{cg_statements_search}
\alias{cg_statements_recent}
\alias{cg_statements_subjects}
\alias{cg_statements_date}
\alias{cg_statements_subject}
\alias{cg_statements_member}
\title{statements methods}
\usage{
cg_statements_search(query, key = NULL, as = "table", ...)

cg_statements_recent(key = NULL, as = "table", ...)

cg_statements_subjects(key = NULL, as = "table", ...)

cg_statements_date(date, key = NULL, as = "table", ...)

cg_statements_subject(subject, key = NULL, as = "table", ...)

cg_statements_member(member_id, congress, key = NULL, as = "table", ...)
}
\arguments{
\item{query}{(character) a search term}

\item{key}{your ProPublica API key; pass in or loads from environment variable
stored as \code{PROPUBLICA_API_KEY} in either your .Renviron, or similar file
locatd in your home directory}

\item{as}{(character) IGNORED FOR NOW}

\item{...}{optional curl options passed on to \link[crul:HttpClient]{crul::HttpClient}.
See \code{\link[curl:curl_options]{curl::curl_options()}}}

\item{date}{(character) a date, of the form YYYY-MM-DD}

\item{subject}{(character) slug version of subject}

\item{member_id}{(character) The ID of the member to retrieve; it is
assigned by the Biographical Directory of the United States Congress
(http://bioguide.congress.gov/biosearch/biosearch.asp) or can be retrieved
from a \code{\link[=cg_members]{cg_members()}} request}

\item{congress}{(character) The number of the Congress this update
took place during.}
}
\value{
various things for now, since return objects vary quite a bit
among the different votes routes
}
\description{
statements methods
}
\examples{
\dontrun{
cg_statements_recent()
cg_statements_subjects()
cg_statements_search("AHCA")
cg_statements_date("2017-01-03")
cg_statements_subject('immigration')
cg_statements_member('C001084', 115)
}
}
