% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_toString.R
\name{tostring}
\alias{tostring}
\alias{toString,VTableTree-method}
\title{Convert an \code{rtable} object to a string}
\usage{
\S4method{toString}{VTableTree}(x, widths = NULL, col_gap = 3, linesep = "—")
}
\arguments{
\item{x}{table object}

\item{widths}{widths of row.name and columns columns}

\item{col_gap}{gap between columns}

\item{linesep}{character to create line separator}
}
\value{
a string representation of \code{x} as it appears when printed.
}
\description{
Convert an \code{rtable} object to a string
}
\examples{
library(dplyr)

iris2 <- iris \%>\%
  group_by(Species) \%>\%
  mutate(group = as.factor(rep_len(c("a", "b"), length.out = n()))) \%>\%
  ungroup()

l <- basic_table() \%>\%
  split_cols_by("Species") \%>\%
  split_cols_by("group") \%>\%
  analyze(c("Sepal.Length", "Petal.Width"), afun = list_wrap_x(summary) , format = "xx.xx")

tbl <- build_table(l, iris2)

cat(toString(tbl, col_gap = 3))
}
