% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_compatibility.R
\name{rbindl_rtables}
\alias{rbindl_rtables}
\alias{rbind,VTableNodeInfo-method}
\alias{rbind}
\alias{rbind2,VTableNodeInfo,missing-method}
\alias{rbind2,VTableNodeInfo,ANY-method}
\title{rbind TableTree and related objects}
\usage{
rbindl_rtables(x, gap = 0, check_headers = TRUE)

\S4method{rbind}{VTableNodeInfo}(..., deparse.level = 1)

\S4method{rbind2}{VTableNodeInfo,missing}(x, y)

\S4method{rbind2}{VTableNodeInfo,ANY}(x, y)
}
\arguments{
\item{x}{VTableNodeInfo. TableTree, ElementaryTable or TableRow object.}

\item{gap}{deprecated. Ignored.}

\item{check_headers}{deprecated. Ignored.}

\item{\dots}{ANY. Elements to be stacked.}

\item{deparse.level}{numeric(1). Currently Ignored.}

\item{y}{VTableNodeInfo. TableTree, ElementaryTable or TableRow object.}
}
\value{
A formal table object.
}
\description{
rbind TableTree and related objects
}
\examples{
mtbl <- rtable(
   header = rheader(
     rrow(row.name = NULL, rcell("Sepal.Length", colspan = 2), rcell("Petal.Length", colspan=2)),
     rrow(NULL, "mean", "median", "mean", "median")
   ),
   rrow(
     row.name = "All Species",
     mean(iris$Sepal.Length), median(iris$Sepal.Length),
     mean(iris$Petal.Length), median(iris$Petal.Length),
     format = "xx.xx"
   )
 )

 mtbl2 <- with(subset(iris, Species == 'setosa'), rtable(
   header = rheader(
     rrow(row.name = NULL, rcell("Sepal.Length", colspan = 2), rcell("Petal.Length", colspan=2)),
     rrow(NULL, "mean", "median", "mean", "median")
   ),
   rrow(
     row.name = "Setosa",
     mean(Sepal.Length), median(Sepal.Length),
     mean(Petal.Length), median(Petal.Length),
     format = "xx.xx"
   )
 ))

 rbind(mtbl, mtbl2)
rbind(mtbl, rrow(), mtbl2)
rbind(mtbl, rrow("aaa"), indent(mtbl2))
}
