% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indent.R
\name{clear_indent_mods}
\alias{clear_indent_mods}
\alias{clear_indent_mods,VTableTree-method}
\alias{clear_indent_mods,TableRow-method}
\title{Clear All Indent Mods from a Table}
\usage{
clear_indent_mods(tt)

\S4method{clear_indent_mods}{VTableTree}(tt)

\S4method{clear_indent_mods}{TableRow}(tt)
}
\arguments{
\item{tt}{TableTree (or related class). A TableTree object representing a
populated table.}
}
\value{
The same class as \code{tt}, with all indent mods set to zero.
}
\description{
Clear All Indent Mods from a Table
}
\examples{
lyt1 <- basic_table() \%>\%
 summarize_row_groups("STUDYID",label_fstr = "overall summary") \%>\%
 split_rows_by("AEBODSYS",  child_labels = "visible") \%>\%
 summarize_row_groups("STUDYID", label = "subgroup summary") \%>\%
 analyze("AGE", indent_mod = -1L)
 
tbl1 <- build_table(lyt1, ex_adae)
tbl1
clear_indent_mods(tbl1)
}
