% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{basic_table}
\alias{basic_table}
\title{Layout with 1 column and zero rows}
\usage{
basic_table(
  title = "",
  subtitles = character(),
  main_footer = character(),
  prov_footer = character(),
  show_colcounts = NA,
  colcount_format = "(N=xx)",
  header_section_div = NA_character_,
  top_level_section_div = NA_character_,
  inset = 0L
)
}
\arguments{
\item{title}{(\code{string})\cr single string to use as main title (\code{\link[formatters:title_footer]{formatters::main_title()}}). Ignored for subtables.}

\item{subtitles}{(\code{character})\cr a vector of strings to use as subtitles (\code{\link[formatters:title_footer]{formatters::subtitles()}}), where every
element is printed on a separate line. Ignored for subtables.}

\item{main_footer}{(\code{character})\cr a vector of strings to use as main global (non-referential) footer materials
(\code{\link[formatters:title_footer]{formatters::main_footer()}}), where every element is printed on a separate line.}

\item{prov_footer}{(\code{character})\cr a vector of strings to use as provenance-related global footer materials
(\code{\link[formatters:title_footer]{formatters::prov_footer()}}), where every element is printed on a separate line.}

\item{show_colcounts}{(\code{logical(1)})\cr Indicates whether the lowest level of
applied to data. \code{NA}, the default, indicates that the \code{show_colcounts}
argument(s) passed to the relevant calls to \verb{split_cols_by*}
functions. Non-missing values will override the behavior specified in
column splitting layout instructions which create the lowest level, or
leaf, columns.}

\item{colcount_format}{(\code{string})\cr format for use when displaying the column counts. Must be 1d, or 2d
where one component is a percent. This will also apply to any displayed higher
level column counts where an explicit format was not specified. Defaults to \code{"(N=xx)"}. See Details below.}

\item{header_section_div}{(\code{string})\cr string which will be used to divide the header from the table. See
\code{\link[=header_section_div]{header_section_div()}} for the associated getter and setter. Please consider changing last element of
\code{\link[=section_div]{section_div()}} when concatenating tables that require a divider between them.}

\item{top_level_section_div}{(\code{character(1)})\cr if assigned a single character, the first (top level) split
or division of the table will be highlighted by a line made of that character. See \link{section_div} for more
information.}

\item{inset}{(\code{numeric(1)})\cr number of spaces to inset the table header, table body, referential footnotes, and
main_footer, as compared to alignment of title, subtitle, and provenance footer. Defaults to 0 (no inset).}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{\link[=build_table]{build_table()}}.
}
\description{
Every layout must start with a basic table.
}
\details{
\code{colcount_format} is ignored if \code{show_colcounts} is \code{FALSE} (the default). When \code{show_colcounts} is \code{TRUE},
and \code{colcount_format} is 2-dimensional with a percent component, the value component for the percent is always
populated with \code{1} (i.e. 100\%). 1d formats are used to render the counts exactly as they normally would be,
while 2d formats which don't include a percent, and all 3d formats result in an error. Formats in the form of
functions are not supported for \code{colcount} format. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for the list
of valid format labels to select from.
}
\note{
\itemize{
\item Because percent components in \code{colcount_format} are \emph{always} populated with the value 1, we can get arguably
strange results, such as that individual arm columns and a combined "all patients" column all list "100\%" as
their percentage, even though the individual arm columns represent strict subsets of the "all patients" column.
\item Note that subtitles (\code{\link[formatters:title_footer]{formatters::subtitles()}}) and footers (\code{\link[formatters:title_footer]{formatters::main_footer()}} and
\code{\link[formatters:title_footer]{formatters::prov_footer()}}) that span more than one line can be supplied as a character vector to maintain
indentation on multiple lines.
}
}
\examples{
lyt <- basic_table() \%>\%
  analyze("AGE", afun = mean)

tbl <- build_table(lyt, DM)
tbl

lyt2 <- basic_table(
  title = "Title of table",
  subtitles = c("a number", "of subtitles"),
  main_footer = "test footer",
  prov_footer = paste(
    "test.R program, executed at",
    Sys.time()
  )
) \%>\%
  split_cols_by("ARM") \%>\%
  analyze("AGE", mean)

tbl2 <- build_table(lyt2, DM)
tbl2

lyt3 <- basic_table(
  show_colcounts = TRUE,
  colcount_format = "xx. (xx.\%)"
) \%>\%
  split_cols_by("ARM")

}
