% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_export.R
\name{data.frame_export}
\alias{data.frame_export}
\alias{as_result_df}
\alias{result_df_specs}
\alias{path_enriched_df}
\title{Generate a Result Data Frame}
\usage{
as_result_df(tt, spec = "v0_experimental", simplify = FALSE, ...)

result_df_specs()

path_enriched_df(tt, path_fun = collapse_path, value_fun = collapse_values)
}
\arguments{
\item{tt}{\code{TableTree} (or related class). A \code{TableTree} object representing a
populated table.}

\item{spec}{character(1). The specification to use to
extract the result data frame. See details}

\item{simplify}{logical(1). If \code{TRUE}, the result data frame will have only visible
labels and result columns.}

\item{...}{Passed to spec-specific result data frame conversion function. Currently it can be
one or more of the following parameters (valid only for \code{v0_experimental} spec for now):
\itemize{
\item \code{expand_colnames}: when \code{TRUE}, the result data frame will have expanded column names above the usual
output. This is useful when the result data frame is used for further processing.
\item \code{simplify}: when \code{TRUE}, the result data frame will have only visible labels and result columns.
\item \code{as_strings}: when \code{TRUE}, the result data frame will have all values as strings, as they appear
in the final table (it can also be retrieved from \code{matrix_form(tt)$strings}). This is also true for
column counts if \code{expand_colnames = TRUE}.
\item \code{as_viewer}: when \code{TRUE}, the result data frame will have all values as they appear in the final table,
i.e. with the same precision and numbers, but in easy-to-use numeric form.
}}

\item{path_fun}{function. Function to transform paths into single-string
row/column names.}

\item{value_fun}{function. Function to transform cell values into cells of
the data.frame. Defaults to \code{collapse_values} which creates strings
where multi-valued cells are collapsed together, separated by \code{|}.}
}
\value{
\code{result_df_specs()}: returns a named list of result data frame extraction functions by "specification".

\code{path_enriched_df()}: returns a data frame of \code{tt}'s cell values (processed by
\code{value_fun}, with columns named by the full column paths (processed by
\code{path_fun} and an additional \code{row_path} column with the row paths
(processed by by \code{path_fun}).
}
\description{
Collection of utilities to exctract \code{data.frame} from \code{TableTree} objects.
}
\details{
\code{as_result_df()}: Result data frame specifications may differ in the exact information
they include and the form in which they represent it. Specifications whose names end in "_experimental"
are subject to change without notice, but specifications without the "_experimental"
suffix will remain available \emph{including any bugs in their construction} indefinitely.
}
\section{Functions}{
\itemize{
\item \code{result_df_specs()}: list of functions that extract result data frames from \code{TableTree}s.

\item \code{path_enriched_df()}: transform \code{TableTree} object to Path-Enriched \code{data.frame}.

}}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("STRATA1") \%>\%
  analyze(c("AGE", "BMRKR2"))

tbl <- build_table(lyt, ex_adsl)
as_result_df(tbl)

result_df_specs()

lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  analyze(c("AGE", "BMRKR2"))

tbl <- build_table(lyt, ex_adsl)
path_enriched_df(tbl)

}
