% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.poisson_rt}
\alias{predict.poisson_rt}
\title{Predict observed data using estimated Rt}
\usage{
\method{predict}{poisson_rt}(object, lambda = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{poisson_rt} produced with \code{\link[=estimate_rt]{estimate_rt()}}.}

\item{lambda}{Select which lambdas from the object to use. If not provided
(the default), all are returned. Note that new lambdas not originally
used in the estimation procedure may be provided, but the results will be
calculated by linearly interpolating the estimated Rt's.}

\item{...}{Not used.}
}
\value{
A vector or matrix of predicted case counts.
}
\description{
Given an object of class \code{poisson_rt} produced with \code{\link[=estimate_rt]{estimate_rt()}},
calculate predicted observed cases for the estimated Rt values.
Note: This function is not intended for "new x" or to produce forecasts, but
rather to examine how Rt relates to observables.
}
\examples{
y <- c(1, rpois(100, dnorm(1:100, 50, 15) * 500 + 1))
out <- estimate_rt(y, nsol = 10)
preds <- predict(out)
plot(y)
matlines(preds, lty = 1)
}
