% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtiesShared.R
\name{actorPartnerDataCross}
\alias{actorPartnerDataCross}
\title{Takes individual cross-sectional data from dyads and turns it into actor-partner format.}
\usage{
actorPartnerDataCross(basedata, dyadId, personId)
}
\arguments{
\item{basedata}{A dataframe with cross-sectional dyadic data.}

\item{dyadId}{The name of variable indicating dyad ID.}

\item{personId}{The name of the variable indicating peron ID.}
}
\value{
A dataframe in actor-partner format.
}
\description{
Need to use a person ID that has first person in dyad numbered 1-n and second person in dyad = ID + some number larger than the number of dyads. Need dyad ID numbered same as for person ID for the first person in the dyad. Both members in each dyad need to have the same number of rows (rows of missing data are ok)
}
\examples{
data <- rties_ExampleDataShort
newData1 <- data[data$time==1, ] # make a cross-sectional dataframe
newData2 <- actorPartnerDataCross(basedata=newData1, dyadId="couple", personId="couple")
head(newData2)

}
