% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtiesShared.R
\name{dataPrep}
\alias{dataPrep}
\title{Reformat a user-provided dataframe in a generic form appropriate for \emph{rties} modeling}
\usage{
dataPrep(
  basedata,
  dyadId,
  personId,
  obs_name,
  dist_name,
  time_name,
  time_lag = NULL
)
}
\arguments{
\item{basedata}{A user-provided dataframe that includes all variables needed for an rties analysis.}

\item{dyadId}{The name of the column in the dataframe that has the dyad-level identifier.}

\item{personId}{The name of the column in the dataframe that has the person-level identifier.}

\item{obs_name}{The name of the column in the dataframe that has the time-varying observable (e.g., the variable for which dynamics will be assessed).}

\item{dist_name}{The name of the column in the dataframe that has a variable that distinguishes the partners (e.g., sex, mother/daughter, etc) that is numeric and scored 0/1.}

\item{time_name}{The name of the column in the dataframe that indicates sequential temporal observations.}

\item{time_lag}{An optional argument for the number of lags for the lagged observable. If a number is provided, the observed variable is lagged that amount. The other option is to use "absMaxCC". In this case the maximum cross-correlation is found for each dyad and the lag at which that occurs is used to lag their observed variables.}
}
\value{
The function returns a dataframe that has all the variables needed for modeling system dynamics, each renamed to a generic variable name, which are:
\itemize{
\item id = person id
\item dyad = dyad id
\item obs = observed state variable
\item dist1 = 0/1 variable where the 1's indicate the 1's in the original distinguishing variable
\item time = the variable indicating temporal sequence
\item dist0 = 0/1 variable where the 1's indicate the 0's in the original distinguishing variable
\item obs_deTrend = the observed state variable with each person's linear trend removed
\item p_ = all the same variables, but for a person's partner rather than themselves
}
}
\description{
The dataframe must be in a specific format and include several specific variables. See the "overview_data_prep" vignette for complete details on the necessary format and follow it closely if you'd like to avoid error messages. That vignette also includes information on how to structure the data if you have two variables within people (rather thean two people within dyads) or have indistinguishable dyads.
}
\examples{
data <- rties_ExampleDataShort
newData <- dataPrep(basedata=data, dyadId="couple", personId="person", obs_name="dial", 
dist_name="female", time_name="time", time_lag=2)
head(newData) 
 
}
