% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sysVarPlots.R
\name{sysVarOutPlots}
\alias{sysVarOutPlots}
\title{Produces plots for interpreting the results from sysVarIn.}
\usage{
sysVarOutPlots(
  fullData,
  sysVar_name,
  sysVarType,
  testModel,
  dist0name = NULL,
  dist1name = NULL,
  binomial = F
)
}
\arguments{
\item{fullData}{A dataframe created by the "makeFullData" function.}

\item{sysVar_name}{The name of the variable in the dataframe that contains the system variable.}

\item{sysVarType}{Whether the system variable is "dyadic", which means both partners have the same score, or "indiv" which means the partners can have different scores}

\item{testModel}{The name of the model that is being interpreted (e.g., sysIn$models$sysVarInteract).}

\item{dist0name}{An optional name for the level-0 of the distinguishing variable (e.g., "Women"). Default is dist0.}

\item{dist1name}{An optional name for the level-1 of the distinguishing variable (e.g., "Men"). Default is dist1}

\item{binomial}{Whether the system variable is binomial. Default is false.}
}
\value{
Single plots or a list of plots (depending on the model that is being interpreted).
}
\description{
Produces plots for interpreting the results from sysVarIn.
}
\examples{
# See vignettes for examples.

}
