% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_params.R
\name{theta2theta}
\alias{theta2theta}
\alias{set_thetas_equal}
\title{Set process probabilities equal}
\usage{
theta2theta(model, names, keep_consts = FALSE)

set_thetas_equal(model, names, keep_consts = FALSE)
}
\arguments{
\item{model}{A list of the class \code{ertmpt_model}.}

\item{names}{Character vector giving the names of the processes for which the process probabilities should be equal. If 
\code{length(names) = 1} then the corresponding process probability will be estimates (i.e., it will be set to NA)}

\item{keep_consts}{Can be one of the following
\itemize{
 \item logical value: \code{FALSE} (default) means none of the constants for \code{names} in the \code{model} will be kept; The probability of
   the reference process (i.e., first of \code{names} in alphabetical order) will be set to \code{NA} (i.e., will be estimated) and the others
   will be set to the name of the reference process (i.e., will be set to equal the reference process probability). \code{TRUE} means
   the constant of the reference process probability (if specified) is used for all other processes. 
 \item numeric value: index for \code{names}. If 1, the constant of the first process in \code{names} (in original order defined by the user) is 
   used for all other probabilities of the processes in \code{names}. If 2, the constant of the second process is used. And so on.
}}
}
\value{
A list of the class \code{ertmpt_model}.
}
\description{
Setting multiple process probabilities (thetas) equal. One of the process probabilities will be estimated and
  the other named process(es) will be set to equal the former. The equality can be removed by only using one name of a process.
}
\note{
If you use \code{theta2theta()} and \code{tau2tau()} with the same process names you might just change the EQN or MDL file accordingly
  by using the same process name for all processes which should have equal process times and probabilities.
}
\examples{
####################################################################################
# Detect-Guess variant of the Two-High Threshold model.
# The encoding and motor execution times are assumed to be equal for each category.
# The process probabilities for both detection processes ("do" and "dn") will be
# set equal.
####################################################################################

mdl_2HTM <- "
# targets
do+(1-do)*g
(1-do)*(1-g)

# lures
(1-dn)*g
dn+(1-dn)*(1-g)

# do: detect old; dn: detect new; g: guess
"

model <- to_ertmpt_model(mdl_file = mdl_2HTM)

## make do = dn
new_model <- theta2theta(model = model, names = c("do", "dn"))
new_model


## make do = dn
new_model <- set_thetas_equal(model = model, names = c("do", "dn"))
new_model
}
\seealso{
\code{\link{delta2delta}}, \code{\link{theta2const}}, \code{\link{tau2zero}} and \code{\link{tau2tau}}
}
\author{
Raphael Hartmann
}
