% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rtoot}
\alias{rtoot}
\title{Query Mastodon API}
\usage{
rtoot(
  endpoint,
  ...,
  params = list(),
  token = NULL,
  instance = NULL,
  anonymous = FALSE
)
}
\arguments{
\item{endpoint}{character, a Mastodon API endpoint. Currently, only endpoints using GET are supported}

\item{...}{Name-value pairs giving API parameters.}

\item{params}{list, API parameters to be submitted}

\item{token}{user bearer token (read from file by default)}

\item{instance}{character, the server name of the instance where the status is located. If \code{NULL}, the same instance used to obtain the token is used.}

\item{anonymous}{some API calls do not need a token. Setting anonymous to TRUE allows to make an anonymous call if possible.}
}
\value{
a list
}
\description{
This is a minimalistic interface for querying the Mastodon API. This function is for advanced users who want to query
the Mastodon API for endpoints that the R functions are not yet implemented.
Please also note that the API responses will not be parsed as tibble. Refer to the official API documentation for endpoints and parameters.
}
\examples{
\dontrun{
rtoot(endpoint = "api/v1/notifications")
rtoot(endpoint = "api/v1/notifications", limit = 8)
## same
rtoot(endpoint = "api/v1/notifications", params = list(limit = 8))
rtoot(endpoint = "api/v1/followed_tags")
## reimplement `get_timeline_public`
rtoot(endpoint = "api/v1/timelines/public", instance = "emacs.ch", local = TRUE, anonymous = TRUE)
}
}
\references{
https://docs.joinmastodon.org/methods/
}
