% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.R
\name{rtry_explore}
\alias{rtry_explore}
\title{Explore data}
\usage{
rtry_explore(input, ..., sortBy = "", showOverview = TRUE)
}
\arguments{
\item{input}{Data frame or data table, e.g. from \code{rtry_import()}.}

\item{\dots}{Attribute names to group together.}

\item{sortBy}{(Optional) Default \code{""} indicates no sorting is applied to the grouped data.
Specify the attribute name used to re-order the rows in ascending order.}

\item{showOverview}{Default \code{TRUE} displays the dimension of the result data table.}
}
\value{
A data frame of unique values grouped and sorted by the specified attribute(s).
}
\description{
This function takes a data frame or data table and converts it into a grouped data frame of unique values
based on the specified column names. A column (\code{Count}) is added, which shows the number of records
within each group. The data are grouped by the first attribute if not specified with the argument \code{sortBy}.
}
\examples{
# Explore the unique values in the provided sample data (data_TRY_15160)
# based on the attributes AccSpeciesID, AccSpeciesName, TraitID, TraitName, DataID
# and DataName, sorted by TraitID
data_explore <- rtry_explore(data_TRY_15160,
                  AccSpeciesID, AccSpeciesName, TraitID, TraitName, DataID, DataName,
                  sortBy = TraitID)

# Expected message:
# dim:   235 7

# Learn more applications of the explore function via the vignette (Workflow for
# general data preprocessing using rtry): vignette("rtry-workflow-general").
}
\references{
This function makes use of the \code{\link[dplyr]{group_by}}, \code{\link[dplyr]{summarise}}
and \code{\link[dplyr]{arrange}} functions within the \code{dplyr} package.
}
