% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_row.R
\name{rtry_select_row}
\alias{rtry_select_row}
\title{Select rows}
\usage{
rtry_select_row(
  input,
  ...,
  getAncillary = FALSE,
  rmDuplicates = FALSE,
  showOverview = TRUE
)
}
\arguments{
\item{input}{Input data frame or data table.}

\item{\dots}{Criteria for row selection.}

\item{getAncillary}{Default \code{FALSE}, set to \code{TRUE} selects all ancillary data based on the row selection criteria.}

\item{rmDuplicates}{Default \code{FALSE}, set to \code{TRUE} calls the function \code{\link{rtry_remove_dup}}.}

\item{showOverview}{Default \code{TRUE} displays the dimension of the data after row selection.}
}
\value{
An object of the same type as the input data.
}
\description{
This function selects rows based on specified criteria
and the corresponding \code{ObservationID} from the imported data for further processing.
}
\note{
This function by default filters data based on the unique identifier \code{ObservationID}
listed in the TRY data, therefore, if the column \code{ObservationID} has been removed,
this function will not work.
}
\examples{
# Within the provided sample data (data_TRY_15160) select the georeferenced traits
# records together with records for Latitude and Longitude (DataID 59 and 60) and
# exclude duplicate trait records
data_selected <- rtry_select_row(data_TRY_15160,
                   (TraitID > 0) | (DataID \%in\% c(59, 60)),
                   getAncillary = TRUE,
                   rmDuplicates = TRUE)

# Expected message:
# 45 duplicates removed.
# dim:   1737 28
}
\references{
This function makes use of the \code{\link[base]{unique}} and \code{\link[base]{subset}} functions
within the \code{base} package. It also uses the function \code{\link{rtry_remove_dup}}.
}
