% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_functions.R
\name{create_points}
\alias{create_points}
\title{Create sf object from point location data}
\usage{
create_points(
  data,
  pos_vars = c("lat", "long"),
  t_var = NULL,
  format = "\%Y-\%m-\%d",
  verbose = TRUE
)
}
\arguments{
\item{data}{data.frame with the x- and y-coordinate of case locations and the date
of the case.}

\item{pos_vars}{vector of length two with the names of the columns
containing the y and x coordinates, respectively.}

\item{t_var}{character string with the name of the column with the date of the case. If single-period
analysis then set t_var to NULL.}

\item{format}{character string with the format of the date specified by t_var. See
\link[base]{strptime}}

\item{verbose}{Logical indicating whether to print information}
}
\value{
An sf object of the same size as \code{data}
}
\description{
Produces an sf object with location and time of cases from a data frame
}
\details{
Given a data frame containing the point location and date of cases, the function
will return an sf object of the points with the date information.
}
\examples{
dp <- data.frame(y=runif(10,0,3),x=runif(10,0,3),date=paste0("2021-01-",11:20))
dp <- create_points(dp,pos_vars = c('y','x'),t_var='date')
}
