% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtsplot.r
\docType{package}
\name{rtsplot}
\alias{rtsplot}
\title{`rtsplot` - Time series plot with base R Graphics.}
\usage{
rtsplot(
  y,
  main = NULL,
  plotX = TRUE,
  LeftMargin = 0,
  grid = "xy",
  x.highlight = NULL,
  y.highlight = NULL,
  y.highlight.col = NULL,
  las = 1,
  type = "l",
  xlab = "",
  ylab = "",
  ylim = NULL,
  log = "",
  skip.breaks = FALSE,
  ...
)
}
\arguments{
\item{y}{\code{\link{xts}} object}

\item{main}{plot title}

\item{plotX}{flag to display X axis}

\item{LeftMargin}{to plot second Y axis, set LeftMargin=3, \strong{defaults to 0}}

\item{grid}{which grid lines to draw, \strong{defaults to 'xy'}}

\item{x.highlight}{segments to highlight along X axis, \strong{defaults to NULL}}

\item{y.highlight}{segments to highlight along Y axis, \strong{defaults to NULL}}

\item{y.highlight.col}{color to highlight segments Y axis, \strong{defaults to NULL}}

\item{las}{rotation of Y axis labels, \strong{defaults to 1}, for more info see \code{\link{par}}}

\item{type}{plot type, \strong{defaults to 'l'}, for more info see \code{\link{plot}}
also support 'ohlc', 'hl', 'candle', 'volume' types}

\item{xlab}{X label, \strong{defaults to ''}, for more info see \code{\link{plot}}}

\item{ylab}{Y label, \strong{defaults to ''}, for more info see \code{\link{plot}}}

\item{ylim}{range on Y values, \strong{defaults to NULL}}

\item{log}{log scale x, y, xy axes, \strong{defaults to ''}}

\item{skip.breaks}{flag to skip plotting missing date/times (i.e. nights and weekends), \strong{defaults to FALSE}}

\item{...}{additional parameters to the \code{\link{plot}}}
}
\value{
nothing
}
\description{
Plot time series data with base R Graphics.

The `rtsplot` package is **fast** time series plot package with base R Graphics.
}
\examples{
# generate time series data
y = rtsplot.fake.stock.data(1000)
symbol = 'Test'

sma = TTR::SMA(y, 250)
rsi = TTR::RSI(y, 20)	

# plot candles and RSI charts
layout(c(1,1,1,2))
cols = rtsplot.colors(2)
	
rtsplot(y, type = 'l', plotX = FALSE, col=cols[1],lwd=1.5)
	rtsplot.lines(sma, col=cols[2], lwd=1.5)
	rtsplot.legend(c(symbol, 'SMA(250)'), cols[1:2], list(y,sma))
	
# plot rsi
rtsplot(rsi, type = 'l', ylim=c(0,100),
	y.highlight = c(c(0,30), c(70,100)),
	y.highlight.col = grDevices::adjustcolor(c('green','red'), 50/255)
)	
rtsplot.legend('RSI(20)', 'black', rsi)


y = rtsplot.fake.stock.data(1000)
symbol = 'SPY'
	
 # simple example
 highlight = which(y < 10)

 # plot
 layout(1)
 rtsplot.theme.set(col.x.highlight=grDevices::adjustcolor('orange', 200/255))
		
 rtsplot(y, type = 'l', main = symbol, x.highlight = highlight)


 # 'skip.breaks' example with daily data
 y = rtsplot.fake.stock.data(7, remove.non.trading = TRUE)
 
 layout(1:2)
 rtsplot(y, type='b')
	rtsplot.legend('skip.breaks=FALSE', text.col='red')
 rtsplot(y, type='b', skip.breaks=TRUE)
	rtsplot.legend('skip.breaks=TRUE', text.col='red')
 

 # 'skip.breaks' example with intra-day data
 y = rtsplot.fake.stock.data(5*24*60, period = 'minute', remove.non.trading = TRUE)
 
 layout(1:2)
 rtsplot(y, type='l')
	rtsplot.legend('skip.breaks=FALSE', text.col='red')
 rtsplot(y, type='l', skip.breaks=TRUE)
	rtsplot.legend('skip.breaks=TRUE', text.col='red')
 

}
