% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_stream.R
\name{stream}
\alias{stream}
\alias{filtered_stream}
\alias{stream_add_rule}
\alias{stream_rm_rule}
\alias{sample_stream}
\title{Streaming}
\usage{
filtered_stream(
  timeout,
  file = tempfile(),
  expansions = NULL,
  fields = NULL,
  ...,
  token = NULL,
  append = TRUE,
  parse = TRUE
)

stream_add_rule(query, dry = FALSE, token = NULL)

stream_rm_rule(query, dry = FALSE, token = NULL)

sample_stream(
  timeout,
  file = tempfile(),
  expansions = NULL,
  fields = NULL,
  ...,
  token = NULL,
  parse = TRUE,
  append = TRUE
)
}
\arguments{
\item{timeout}{time, in seconds, of the recording stream.}

\item{file}{Path to a file where the raw streaming should be stored.}

\item{expansions}{Set \code{NULL} to not use any expansion, set \code{NA} to get all
expansions, or provide a vector with the expansions you want (create it with
\code{\link[=set_expansions]{set_expansions()}}).}

\item{fields}{Set \code{NULL} to not use any field, get all allowed fields with \code{NA},
provide a list with the fields you want (create it with \code{\link[=set_fields]{set_fields()}}).}

\item{...}{Other parameters passed to the body of the request.}

\item{token}{These endpoints only accept a bearer token (can be created via
\code{\link[=rtweet_app]{rtweet_app()}}). In most cases you
are better of changing the default for all calls via \code{\link[=auth_as]{auth_as()}}.}

\item{append}{Append streaming to the file? Default does but it is
recommended to have a new file for each call.}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}

\item{query}{If \code{NULL} returns the current rules, else depending:
\itemize{
\item In stream_add_rule it should be a list of value and tag.
\item In stream_rm_rule it should be a vector of ids of rules to be removed
}}

\item{dry}{Check if the addition or removal of the rule works.}
}
\value{
The records in the streaming.
}
\description{
Open a streaming connection with Twitter and stores tweets for as long as you
wish.
}
\details{
The connection can be left open as long as you wish, the data is appended to
the file provided. Be aware that the stream might have incomplete records
(you won't be able to read directly from the json file).
One tweet might belong to multiple rules.
}
\section{Functions}{
\itemize{
\item \code{filtered_stream()}: Start a filtered stream according to the rules.

\item \code{stream_add_rule()}: Add rules for the filtered streaming.

\item \code{stream_rm_rule()}: Remove rules from the filtered streaming

\item \code{sample_stream()}: Retrieve a sample of the tweets posted.

}}
\examples{
# Requires a bearer token
if (FALSE) {
  # How many rules do we have
  stream_add_rule(NULL)
  # Add new rule
  new_rule <- stream_add_rule(list(value = "#rstats", tag = "rstats"))
  new_rule
  # Open filtered streaming connection for 30s
  filtered_stream(file = tempfile(), timeout = 30, parse = FALSE)
  # Remove rule
  stream_rm_rule(ids(new_rule))
  # Open random streaming connection
  sample_stream(file = tempfile(), timeout = 3, parse = FALSE)
}
}
\seealso{
Rules for filtered stream: \url{https://developer.twitter.com/en/docs/twitter-api/tweets/filtered-stream/integrate/build-a-rule}

Sampled stream: \url{https://developer.twitter.com/en/docs/twitter-api/tweets/volume-streams/api-reference/get-tweets-sample-stream}

Filtered stream: \url{https://developer.twitter.com/en/docs/twitter-api/tweets/filtered-stream/api-reference/get-tweets-search-stream}

\code{\link[=ids]{ids()}}
}
