% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCA_Server.R
\name{apply_route_map}
\alias{apply_route_map}
\title{Applies Route Mapping to Dataset}
\usage{
apply_route_map(route_map = list(), route_col = NULL, DS = NULL)
}
\arguments{
\item{route_map}{List with names corresponding to the route replacement and
a vector of regular expressions to match.}

\item{route_col}{Column name with the route data.}

\item{DS}{Dataframe containing the dataset.}
}
\value{
Dataset with the route mapping applied.
}
\description{
Used to convert nonstandard dose route values (i.e. "IV") to
standard values ("intravascular").
}
\examples{
if(system.file(package="readxl") !=""){
library(readxl)
#loading a dataset
data_file =  system.file(package="formods","test_data","TEST_DATA.xlsx")
myDS = readxl::read_excel(path=data_file, sheet="DATA")

 route_map = list(
   intravascular = c("^(?i)iv$"),
   extravascular = c("^(?i)sc$", "^(?i)oral")
 )

utils::head(myDS[["ROUTE"]])

myDS = apply_route_map(route_map = route_map,
                       route_col = "ROUTE",
                       DS        = myDS)

utils::head(myDS[["ROUTE"]])
}
}
