% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/combine.mcmc.R
\name{combine.mcmc}
\alias{combine.JAGS}
\alias{combine.MCMC}
\alias{combine.jags}
\alias{combine.mcmc}
\alias{divide.JAGS}
\alias{divide.jags}
\title{Combining and dividing runjags and MCMC objects}
\usage{
combine.mcmc(mcmc.objects = list(), thin = 1, return.samples = NA,
  collapse.chains = if (length(mcmc.objects) == 1) TRUE else FALSE,
  vars = NA, add.mutate = TRUE)

combine.jags(runjags.objects = list(), summarise = TRUE, ...)

divide.jags(runjags.object,
  which.chains = 1:nchain(as.mcmc.list(runjags.object)), summarise = TRUE,
  ...)
}
\arguments{
\item{mcmc.objects}{a list of MCMC or runjags objects, all with the same number of chains and matching variable names, or a single MCMC object/list or runjags object.  No default.}

\item{thin}{an integer to use to thin the (final) MCMC object by, in addition to any thinning already applied to the objects before being passed to combine.mcmc.  Ignored if return.samples is specified (!is.na).  Default 1 (no additional thinning is performed).}

\item{return.samples}{the number of samples to return after thinning.  The chains will be thinned to as close to this minimum value as possible, and any excess iterations discarded.  Supersedes thin if  both are specified.  Ignored if niter(mcmc.objects) < return.samples.   Default NA.}

\item{collapse.chains}{option to combine all MCMC chains into a single MCMC chain with more iterations.  Can be used for combining chains prior to calculating results in order to reduce the Monte Carlo error of estimates.  Default TRUE if a single mcmc.object is provided, or FALSE otherwise.}

\item{vars}{an optional character vector of variable names to extract.  If supplied, only variable names in the object supplied with a partial match to anything in 'vars' will be used.  Note that regular expressions are not allowed, but the caret (^) token can be used to specify the match at the start of a variable name, and a quoted vars will be matched exactly.  Default NA meaning all variables available are returned.}

\item{add.mutate}{should any mutate function associated with the runjags objects be run to collect the additional variables before returning MCMC chains?}

\item{runjags.objects}{a list of runjags class objects to be combined}

\item{summarise}{option to add a new set of summary statistics to the newly created runjags object}

\item{...}{other arguments to be passed to \code{\link{add.summary}}}

\item{runjags.object}{a single runjags class object to be divided}

\item{which.chains}{the chains to extract from the runjags object}
}
\value{
For combine.mcmc:  an MCMC object if collapse.chains=TRUE, or an mcmc.list object if collapse.chains=FALSE

For combine.jags and divide.jags:  a \code{\link{runjags-class}} object
}
\description{
Utility functions for combining separate MCMC or runjags objects into a single object, or the reverse operation
}
\details{
The combine.mcmc function allows an MCMC object (with 1 or more chains) to be combined with object(s) representing extensions of the same simulation, to produce one MCMC object that contains the continuous combined Markov chains.  Alternatively, a single MCMC list object can be converted into a single chain by combining all chains sequentially.  An object of class \code{\link{runjags-class}} can also be used, in which case the MCMC objects will be extracted from this.  The combine.jags function does a similar operation, but returning the entire runjags object as a single object that can be extended using \code{\link{extend.jags}}.  The divide.jags extracts one or more chains from a given runjags object.
}
\seealso{
\code{\link{run.jags}} and \code{\link{runjags-class}}
}
\keyword{methods}

