% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSymbols.MarketWatch.R
\name{getSymbols.MarketWatch}
\alias{getSymbols.MarketWatch}
\title{MarketWatch Alor data}
\usage{
getSymbols.MarketWatch(
  Symbols,
  env = globalenv(),
  from = "2007-01-01",
  to = Sys.Date(),
  adjust = FALSE,
  period = "day",
  market = NULL,
  countrycode = NULL,
  verbose = FALSE,
  auto.assign = FALSE,
  ...
)
}
\arguments{
\item{Symbols}{A character vector specifying the name of the financial instrument(s) to retrieve.}

\item{env}{An environment where the data should be loaded.}

\item{from}{A character string specifying the starting date for the historical data in the format "YYYY-MM-DD".}

\item{to}{A character string specifying the ending date for the historical data in the format "YYYY-MM-DD".}

\item{adjust}{A logical value indicating whether to adjust the prices for splits and dividends. The default value is FALSE.}

\item{period}{A character string specifying the period for which to retrieve the data. The default value is "day".}

\item{market}{A character string specifying the market where the financial instrument is listed.}

\item{countrycode}{A character string specifying the country code of the market where the financial instrument is listed.}

\item{verbose}{A logical value indicating whether to print additional information while running the function. The default value is FALSE.}

\item{auto.assign}{A logical value indicating whether to assign the data to an R object with the same name as the symbol. The default value is FALSE.}

\item{...}{Additional arguments.}
}
\value{
A data frame or an object of class "xts" containing the historical financial data for the given symbol.
}
\description{
This function retrieves historical financial data for a given symbol from the MarketWatch website and returns it as a data frame or assigns it to an R object.
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
getSymbols.MarketWatch(Symbols = 'liborusd3m',market = 'interestrate',countrycode = 'mr')
getSymbols.MarketWatch(Symbols = 'tmubmusd03m',market = 'bond',countrycode = 'bx')
}
\author{
Vyacheslav Arbuzov
}
