% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{new_network}
\alias{new_network}
\title{Sequential network constructor}
\usage{
new_network(...)
}
\arguments{
\item{...}{Zero or more objects of class \code{"ruta_layer"}}
}
\value{
A construct with class \code{"ruta_network"}
}
\description{
Constructor function for networks composed of several sequentially placed
layers. You shouldn't generally need to use this. Instead, consider
concatenating several layers with \code{\link{+.ruta_network}}.
}
\examples{
my_network <- new_network(
  new_layer("input", 784, "linear"),
  new_layer("dense",  32, "tanh"),
  new_layer("dense", 784, "sigmoid")
)

# Instead, consider using
my_network <- input() + dense(32, "tanh") + output("sigmoid")
}
