% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivplot.R
\name{ivplot}
\alias{ivplot}
\title{Interval plot}
\usage{
ivplot(X, name = "", file.name = "", split = NULL,
  Intervals = NULL, xlim, left.margin = 3, x.ticks = NULL,
  exp.labels = FALSE, xlab = "", title = "", top.axis = FALSE,
  use_color = TRUE, vline = NULL, device = "X11", size = c(297,
  210)/25.4/2, font.family = "Courier", cex.label = NULL, ...)
}
\arguments{
\item{X}{A data frame providing data for creating one interval per row. See
details below.}

\item{name}{Name of file to produce}

\item{file.name}{Name of file to produce}

\item{split}{Name of column by which to divide the plot into groups.}

\item{Intervals}{A list defining what intervals or dots to output per each
row.}

\item{xlim}{Numeric vector of length 2. Limits for the horizontal axis.}

\item{left.margin}{Scalar. Size of left margin. If labels take too much
space, increase this (default is 3)}

\item{x.ticks}{Numeric vector.}

\item{exp.labels}{Logical. Use log scale? Then print numeric values at
x-ticks in the original (exponentiated) scale}

\item{xlab}{Character.}

\item{title}{Character; title.}

\item{top.axis}{Logical. Print top axis?}

\item{use_color}{Logical. Use color in plot or black?}

\item{vline}{Scalar. Plot vertical line (will be plotted before intervals
are}

\item{device}{Character. To which device to output?}

\item{size}{Numeric vector of length 2.  Size of plot: vertical and
horizontal sizes in inches.}

\item{font.family}{Character. Font family (sans (Helvetica), serif (Times),
mono (Courier), ...)}

\item{cex.label}{number, a factor to shrink the 'cex' of the labels, between
0 and 1}

\item{\dots}{Other arguments passed to \code{plot}}
}
\value{
The file name that was output; as a side effect a plot (a pdf file
if \code{device="pdf"}.)
}
\description{
Create a plot based on a data frame providing endpoints of intervals,
colors, line weights etc.
}
\details{
...
}
\author{
J Kerman
}
\keyword{hplot}
