% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvMF.R
\name{vMFangle}
\alias{vMFangle}
\alias{rvMFangle}
\alias{dvMFangle}
\title{Inner Product of von Mises-Fisher Random Vector and Mean Direction}
\usage{
rvMFangle(n, p, kappa)

dvMFangle(r, p, kappa)
}
\arguments{
\item{n}{number of random vectors to generate.}

\item{p}{dimension of the sphere. i.e.,
\ifelse{html}{\out{S<sup>p-1</sup>}}{\eqn{S^{p-1}}}, \eqn{p\ge 2}.}

\item{kappa}{concentration parameter. \eqn{kappa > 0}. Setting \code{kappa=0} may
cause errors.}

\item{r}{vector of quantiles. \eqn{-1\le r\le 1}.}
}
\value{
\itemize{
\item \code{rvMFangle()} returns a vector whose components independently follow the
aforementioned distribution. The length of the result is determined by \code{n}
for \code{rvMFangle()}.
\item \code{dvMFangle()} returns a vector of density function value. The length of the
result is determined by the length of \code{r} for \code{dvMFangle()}.
}
}
\description{
These functions provide information about the distribution of an inner
product between von Mises-Fisher random vector and its mean direction.
Specifically, if \eqn{X} follows a von Mises-Fisher distribution with mean
direction \eqn{\mu}, the inner product \eqn{X'\mu} will be a random variable
following some distribution. See page 170 of Mardia and Jupp (1999).
\code{rvMFangle()} generates random variates, and \code{dvMFangle} gives the density
from this distribution. This function partly uses the code from the article
Marsaglia et al. (2004).
}
\examples{
rvMFangle(10, 2, 10)
rvMFangle(10, 3, 0.1)
dvMFangle(seq(-1,1,by=0.01), 2, 10)
dvMFangle(seq(0,1,by=0.01), 3, 0.1)
}
\references{
K. V. Mardia and P. E. Jupp. Directional Statistics, volume 494. John Wiley
& Sons, Chichester, 1999.

G. Marsaglia, W. W. Tsang, and J. Wang. Fast generation of discrete random
variables. Journal of Statistical Software, 11(3):1–11, 2004.
}
\seealso{
\link{rvMF} wrapper of \code{rvMFangle()}.
}
