% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dunif_rvec}
\alias{dunif_rvec}
\alias{punif_rvec}
\alias{qunif_rvec}
\alias{runif_rvec}
\title{Uniform Distribution, Using Multiple Draws}
\usage{
dunif_rvec(x, min = 0, max = 1, log = FALSE)

punif_rvec(q, min = 0, max = 1, lower.tail = TRUE, log.p = FALSE)

qunif_rvec(p, min = 0, max = 1, lower.tail = TRUE, log.p = FALSE)

runif_rvec(n, min = 0, max = 1, n_draw = NULL)
}
\arguments{
\item{x}{Quantiles. Can be an rvec.}

\item{min}{Lower limits. Default is \code{0}.
See \code{\link[stats:Uniform]{stats::dunif()}}. Can be an rvec.}

\item{max}{Upper limited. Default is \code{1}.
See \code{\link[stats:Uniform]{stats::dunif()}}. Can be an rvec.}

\item{log, log.p}{Whether to return results
on a log scale. Default is
\code{FALSE}. Cannot be an rvec.}

\item{q}{Quantiles. Can be an rvec.}

\item{lower.tail}{Whether to return
\eqn{P[X \le x]}, as opposed to
\eqn{P[X > x]}. Default is \code{TRUE}.
Cannot be an rvec.}

\item{p}{Probabilities. Can be an rvec.}

\item{n}{The length of random vector being
created. Cannot be an rvec.}

\item{n_draw}{Number of random draws
in the random vector being
created. Cannot be an rvec.}
}
\value{
\itemize{
\item If any of the arguments are rvecs,
or if a value for \code{n_draw} is supplied,
then an \link[=rvec]{rvec}
\item Otherwise an ordinary R vector.
}
}
\description{
Density, distribution function,
quantile function and random generation for the
uniform distribution, modified to work with
rvecs.
}
\details{
Functions \code{dunif_rvec()}, \code{punif_rvec()},
\code{punif_rvec()} and \code{runif_rvec()} work like
base R functions \code{\link[=dt]{dt()}}, \code{\link[=pt]{pt()}},
\code{\link[=qt]{qt()}}, and \code{\link[=rt]{rt()}}, except that
they accept rvecs as inputs. If any
input is an rvec, then the output will be too.
Function \code{runif_rvec()} also returns an
rvec if a value for \code{n_draw} is supplied.

\code{dunif_rvec()}, \code{punif_rvec()},
\code{punif_rvec()} and \code{runif_rvec()}
use \link[vctrs:theory-faq-recycling]{tidyverse}
vector recycling rules:
\itemize{
\item Vectors of length 1 are recycled
\item All other vectors must have the same size
}
}
\examples{
x <- rvec(list(c(0.2, 0.5),
               c(0.6, 0.7)))
dunif_rvec(x)
punif_rvec(x)

runif_rvec(n = 2,
           min = c(0, 0.5),
           n_draw = 1000)
}
\seealso{
\itemize{
\item \code{\link[=dunif]{dunif()}}
\item \code{\link[=punif]{punif()}}
\item \code{\link[=qunif]{qunif()}}
\item \code{\link[=runif]{runif()}}
\item \link[stats:Distributions]{stats::distributions}.
}
}
