% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vinecop_methods.R
\name{mBICV}
\alias{mBICV}
\title{calculates the vine copula Bayesian information criterion (vBIC), which is
defined as
\deqn{\mathrm{BIC} = -2\, \mathrm{loglik} +  \nu \ln(n), - 2 * 
\sum_{t=1}^(d - 1) \{q_t log(\psi_0^t) - (d - t - q_t) log(1 - \psi_0^t)\}
}
where \eqn{\mathrm{loglik}} is the log-likelihood and \eqn{\nu} is the
(effective) number of parameters of the model, \eqn{t} is the tree level
\eqn{\psi_0} is the prior probability of having a non-independence copula and
\eqn{q_t} is the number of non-independence copulas in tree \eqn{t}.
The vBIC is a consistent model
selection criterion for parametric sparse vine copula models.}
\usage{
mBICV(object, psi0 = 0.9)
}
\arguments{
\item{object}{a fitted \code{vinecop} object.}

\item{psi0}{baseline prior probability of a non-independence copula.}
}
\description{
calculates the vine copula Bayesian information criterion (vBIC), which is
defined as
\deqn{\mathrm{BIC} = -2\, \mathrm{loglik} +  \nu \ln(n), - 2 * 
\sum_{t=1}^(d - 1) \{q_t log(\psi_0^t) - (d - t - q_t) log(1 - \psi_0^t)\}
}
where \eqn{\mathrm{loglik}} is the log-likelihood and \eqn{\nu} is the
(effective) number of parameters of the model, \eqn{t} is the tree level
\eqn{\psi_0} is the prior probability of having a non-independence copula and
\eqn{q_t} is the number of non-independence copulas in tree \eqn{t}.
The vBIC is a consistent model
selection criterion for parametric sparse vine copula models.
}
