<p align="center">
<a href="https://selesnow.github.io/"><img src="https://alexeyseleznev.files.wordpress.com/2017/03/as.png" height="80"></a>
</p>

# rvkstat - пакет для работы с API Вконтакте.<a href='https:/selesnow.github.io/rvkstat'><img src='https://raw.githubusercontent.com/selesnow/rvkstat/master/inst/logo/rvkstat.png' align="right" height="139" /></a>

## Краткое описание.

Пакет rvkstat является R клиентом для работы с API социальной сети [Вконтакте](https://vk.com/). С помощью функций данного пакета можно получить статистику из рекламного кабинета Вконтакте, а так же данные о посетителях сообществ вконтакте по дням, в разрезе возрастных групп, пола и геолокации посетителей.

Все функции входящие в пакет rvkstat имеюи префикс vk.

Все функции пакета разделены на блоки, определить к какому блоку относится функция можно из её названия, название блока к которому относится функция идёт сразу после префикса vk:

* Блок функция **GetGroupStat** предназначем для загрузки статистики по сообществам Вконтакте.
* Блок функций **GetAd** направлен на загрузку данных из рекламного кабинета Вконтакте.
* Блок функций **GetDb** даёт возможность загрузки справочной информации из Вконтакте.
* Блок функций **GetUser** используется для загрузки данных о конкретном пользователе Вконтакте.

## Функции rvkstat

Ниже приведено описание всех функций входящих в пакет rvkstat:

+ Авторизация и получение токена
    + `vkAuth` - Прохождение процесса авторизации с помощью метода [Authorization Code Flow](https://vk.com/dev/authcode_flow_user), токен полученный с помощью данной функции будет работать с любого IP.
	+ `vkGetToken` - Упрощённая авторизация по методу [Implicit Flow](https://vk.com/dev/implicit_flow_user), токен доступа пользователя выдаётся с привязкой к IP адресу, в связи с чем при смене IP адреса прийдётся проходить процедуру авторизации. Такой ключ требуется для работы почти со всеми методами нашего API, за исключением методов секции secure. Некоторые методы (как, например, users.get) можно вызывать и без access_token, но часть данных в таком случае может быть недоступна, поскольку имеет значение, для какого пользователя их нужно получить.
	+ `vkGetGroupToken` - Упрощённая авторизация по методу [Implicit Flow](https://vk.com/dev/implicit_flow_group), токен доступа сообщества выдаётся с привязкой к IP адресу, в связи с чем при смене IP адреса прийдётся проходить процедуру авторизации. Такой ключ позволяет работать с API от имени группы, встречи или публичной страницы. Например, с его помощью Вы можете отвечать подписчикам сообщества на сообщения, поступившие в его адрес. С ключом доступа сообщества можно вызывать те методы, которые имеют специальную пометку в общем [списке](https://vk.com/dev/methods). 
+ Функции для загрузки данных из рекламного кабинета Вконтакте
    + `vkGetAdCategories` - Получить возможные тематики рекламных объявлений и их подразделы.
    + `vkGetAdAccounts` - Получить список доступных рекламных кабинетов
    + `vkGetAdClient` - Получить список клиентов из агентского аккаунта
    + `vkGetAds` - Получить список объявлений
    + `vkGetAdsLayout` - Возвращает описания внешнего вида рекламных объявлений.
    + `vkGetAdCampaigns` - Получить список рекламных кампаний
    + `vkGetAdStatistics` - Получить статистику показателей эффективности по рекламным объявлениям, кампаниям, клиентам или всему кабинету
    + `vkGetAdCityStats` - Получить статистику по охвату аудитории по рекламным кампаним или объявления в разрезе городов
    + `vkGetAdGenderStats` - Получить статистику по охвату аудитории по рекламным кампаним или объявления в разрезе пола
    + `vkGetAdAgeStats` - Получить статистику по охвату аудитории по рекламным кампаним или объявления в разрезе возраста
    + `vkGetAdGenderAgeStats` - Получить статистику по охвату аудитории по рекламным кампаним или объявления в разрезе пола и возраста
    + `vkGetAdBudget` - Получить остаток средств из рекламного кабинета
    + `vkGetAdPostsReach` - Получить подробную статистику по охвату рекламных записей из объявлений и кампаний для продвижения записей сообщества
+ Функции для загрузки данных из сообществ Вконтакте
    + `vkGetGroupStat` - Получить общую статистику по сообществу
    + `vkGetGroupStatAge` - Получить данные о посетителях сообщества по возрасту
    + `vkGetGroupStatCity` - Получить данные о посетителях сообщества по городам
    + `vkGetGroupStatCountries` - Получить данные о посетителях сообщества по странам
    + `vkGetGroupStatGender` - Получить данные о посетителях сообщества по полу
    + `vkGetGroupStatGenderAge` - Получить данные о посетителях сообщества по полу и возрасту
    + `vkGetGroupStatPostReach` - Получить детальные данные по охвату по записяписям сообществ
+ Функции для загрузки справочной инормации из Вконтакте
    + `vkGetDbCountries` - Получить id и название стран
    + `vkGetDbCities` - Получить справочник городов
    + `vkGetDbRegions` - Получить справочник регионов
+ Функции для загрузки инормации о пользователе Вконтакте
    + `vkGetUserFriends` - Получить список друзей пользователя Вконтакте
    + `vkGetUserDialogs` - Получить список диалогов текущего пользователя или сообщества
    + `vkGetUserGroups` - Получить список групп и сообществ в которых состоит пользователь Вконтакте
    + `vkGetUserWall` - Получить сообщения со стены пользователя с количеством комментариев, лайков и рипостов

## Как получить подробную справку по функциям пакета rvkstat
Все функции пакета имеют подробное описание, получить детальную справку по любой функции пакета `rvkstat` можно с помощь команды `help`, если вы работаете в RStudio справку так же можно получить указав `?` перед названием комапнды:

`help("vkGetAdStatistics")`	

`?vkGetAdStatistics`

## Установка пакета vkstat.

Установка пакета осуществляется из репозитория CRAN 

`install.packages("rvkstat")`

или GitHub, для этого сначала требуется установить и подключить пакет devtools.

`install.packages("devtools")`

`library(devtools)`

После чего можно устанавливать dev версию пакета rvkstat.

`install_github('selesnow/rvkstat')`

### Ссылки
1. [Документация по работе с пакетом rvkstat](https://selesnow.github.io/rvkstat/).
2. Баг репорты, предложения по доработке и улучшению функционала ryandexdirect оставлять [тут](https://github.com/selesnow/rvkstat/issues). 
3. [Список релизов](https://github.com/selesnow/rvkstat/releases).
4. [Телеграмм канал R4marketing](https://t.me/R4marketing).
5. [Группа в Вконтакте](https://vk.com/data_club).

### Автор пакета
Алексей Селезнёв, Head of analytics dept. at [Netpeak](https://netpeak.net)
<Br>email: selesnow@gmail.com
<Br>skype: selesnow
<Br>facebook: [facebook.com/selesnow](https://facebook.com/selesnow)
<Br>blog: [alexeyseleznev.wordpress.com](https://alexeyseleznev.wordpress.com/)

### Бейджи
[![Rdoc](http://www.rdocumentation.org/badges/version/rvkstat)](http://www.rdocumentation.org/packages/rvkstat)
[![](https://cranlogs.r-pkg.org/badges/rvkstat)](https://cran.r-project.org/package=rvkstat)
