% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aupvb.R
\name{load_aupvb_leaderboards}
\alias{load_aupvb_leaderboards}
\title{Load cleaned aupvb leaderboards data from the volleydata repository}
\usage{
load_aupvb_leaderboards(seasons = NULL)
}
\arguments{
\item{seasons}{An integer or vector of integers of seasons to fetch data for. Defaults to all available seasons.}
}
\value{
Returns a data frame containing leaderboards for the specified seasons.\tabular{ll}{
   Column Name \tab Type \cr
   season \tab dbl \cr
   week_number \tab dbl \cr
   game_number \tab dbl \cr
   game_rank \tab dbl \cr
   first_name \tab chr \cr
   last_name \tab chr \cr
   uniform_number \tab dbl \cr
   total_points \tab dbl \cr
   mvp_points \tab dbl \cr
   win_points \tab dbl \cr
   stat_points \tab dbl \cr
   first_place_mvp \tab lgl \cr
   first_place_total_points \tab dbl \cr
   second_place_mvp \tab lgl \cr
   second_place_total_points \tab dbl \cr
   third_place_mvp \tab lgl \cr
   third_place_total_points \tab dbl \cr
   defensive_mvp \tab lgl \cr
   defensive_mvp_total_points \tab dbl \cr
   set_wins \tab dbl \cr
   set_wins_total_points \tab dbl \cr
   match_win \tab dbl \cr
   match_win_total_points \tab dbl \cr
   service_aces \tab dbl \cr
   service_ace_points \tab dbl \cr
   service_errors \tab dbl \cr
   service_error_points \tab dbl \cr
   attack_kills \tab dbl \cr
   attack_kill_points \tab dbl \cr
   attack_errors \tab dbl \cr
   attack_error_points \tab dbl \cr
   set_assists \tab dbl \cr
   set_assist_points \tab dbl \cr
   set_errors \tab dbl \cr
   set_error_points \tab dbl \cr
   digs \tab dbl \cr
   dig_points \tab dbl \cr
   good_receptions \tab dbl \cr
   good_reception_points \tab dbl \cr
   reception_errors \tab dbl \cr
   reception_error_points \tab dbl \cr
   block_assists \tab dbl \cr
   block_assist_points \tab dbl \cr
   block_stuffs \tab dbl \cr
   block_stuff_points \tab dbl \cr
   points_behind \tab dbl \cr
   has_extra_inning_stats \tab lgl \cr
   is_captain \tab lgl \cr
   roster_status \tab chr \cr
   primary_position_position_lk \tab chr \cr
   primary_position_description \tab chr \cr
   primary_position_short_description \tab chr \cr
   team_name \tab chr \cr
   team_color \tab chr \cr
   team_seed \tab dbl \cr
   season_id \tab dbl \cr
   competitor_id \tab dbl \cr
   player_id \tab dbl \cr
   player_slug \tab chr \cr
   uniform_number_display \tab dbl \cr
   overall_rank \tab dbl \cr
   overall_rank_change \tab dbl \cr
   total_au_points \tab dbl \cr
   percent_change \tab dbl \cr
   position_change \tab dbl \cr
   updated_flg \tab lgl \cr
   tie_flg \tab lgl \cr
   missed_games_flg \tab lgl \cr
   previous_seqno \tab dbl \cr
   has_game_experience \tab dbl \cr
}
}
\description{
Load cleaned aupvb leaderboards data from the volleydata repository
}
\examples{
try({load_aupvb_leaderboards(2024)})
}
