% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FTWT2_PO.R
\name{FTWT2_PO}
\alias{FTWT2_PO}
\title{2-d tensor wavelet transform (periodized, orthogonal).}
\usage{
FTWT2_PO(x, L, qmf)
}
\arguments{
\item{x}{2-d image (n by n array, n dyadic).}

\item{L}{coarse level.}

\item{qmf}{quadrature mirror filter.}
}
\value{
\code{wc} 2-d wavelet transform.
}
\description{
A two-dimensional Wavelet Transform is computed for the array x.
\code{qmf} filter may be obtained from \code{\link{MakeONFilter}}.
To reconstruct, use \code{\link{ITWT2_PO}}.
}
\examples{
qmf <- MakeONFilter('Daubechies', 10)
L <- 0
x <- matrix(rnorm(2^2), ncol=2)
wc <- FTWT2_PO(x, L, qmf)
}
\seealso{
\code{\link{ITWT2_PO}}, \code{\link{MakeONFilter}}.
}
