% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FWT2_TI.R
\name{FWT2_TI}
\alias{FWT2_TI}
\title{2-D Translation Invariant Forward Wavelet Transform.}
\usage{
FWT2_TI(x, L, qmf)
}
\arguments{
\item{x}{2-d image (n by n real array, n dyadic).}

\item{L}{degree of coarsest scale.}

\item{qmf}{orthonormal quadrature mirror filter.}
}
\value{
\code{TIWT} translation-invariant wavelet transform table, (3(J-L)+1)n by n.
}
\description{
1. \code{qmf} filter may be obtained from \code{\link{MakeONFilter}}.
2. usually, \code{length(qmf) < 2^(L+1)}.
3. To reconstruct use \code{\link{IWT_TI}}.
}
\examples{
x <- matrix(rnorm(2^2), ncol=2)
L <- 0
qmf <- MakeONFilter('Haar')
TIWT <- FWT2_TI(x, L, qmf)
}
