% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeplot.splitfreq.matrix.R
\name{makeplot.splitfreq.matrix}
\alias{makeplot.splitfreq.matrix}
\title{Plots a matrix of split frequency comparisons between multiple MCMC chains.}
\usage{
makeplot.splitfreq.matrix(chains, burnin = 0)
}
\arguments{
\item{chains}{A list of rwty.trees objects.}

\item{burnin}{The number of trees to eliminate as burnin}
}
\value{
output A list of two plots: the first is a matrix of scatterplots, where each point is a clade, and the values are the split frequencies of that clade in the post-burnin trees of each chain. The second plot is a tree of the chains clustered by their ASDSFs.
}
\description{
This function takes list of rwty.trees objects, and returns a scatterplot matrix
in which each plot shows the split frequencies of all clades that appear in one or both 
MCMC chains at least once. In the upper diagonal, we show the correlation between the split
frequencies (Pearson's R), and the Average Standard Deviation of the split frequencies.
}
\examples{
data(salamanders)
makeplot.splitfreq.matrix(salamanders[1:4], burnin = 20)
}
\keyword{ASDSF}
\keyword{MCMC,}
\keyword{clade}
\keyword{consensus,}
\keyword{convergence,}
\keyword{frequency,}
\keyword{phylogenetics,}

