% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rxSimThetaOmega}
\alias{rxSimThetaOmega}
\title{Simulate Parameters from a Theta/Omega specification}
\usage{
rxSimThetaOmega(
  params = NULL,
  omega = NULL,
  omegaDf = NULL,
  omegaLower = as.numeric(c(R_NegInf)),
  omegaUpper = as.numeric(c(R_PosInf)),
  omegaIsChol = FALSE,
  omegaSeparation = "auto",
  omegaXform = 1L,
  nSub = 1L,
  thetaMat = NULL,
  thetaLower = as.numeric(c(R_NegInf)),
  thetaUpper = as.numeric(c(R_PosInf)),
  thetaDf = NULL,
  thetaIsChol = FALSE,
  nStud = 1L,
  sigma = NULL,
  sigmaLower = as.numeric(c(R_NegInf)),
  sigmaUpper = as.numeric(c(R_PosInf)),
  sigmaDf = NULL,
  sigmaIsChol = FALSE,
  sigmaSeparation = "auto",
  sigmaXform = 1L,
  nCoresRV = 1L,
  nObs = 1L,
  dfSub = 0,
  dfObs = 0,
  simSubjects = TRUE,
  simVariability = as.logical(c(NA_LOGICAL))
)
}
\arguments{
\item{params}{Named Vector of rxode2 model parameters}

\item{omega}{Estimate of Covariance matrix. When omega is a list,
assume it is a block matrix and convert it to a full matrix for
simulations.  When \code{omega} is \code{NA} and you are using it with a
\code{rxode2} ui model, the between subject variability described by
the \code{omega} matrix are set to zero.}

\item{omegaDf}{The degrees of freedom of a t-distribution for
simulation.  By default this is \code{NULL} which is
equivalent to \code{Inf} degrees, or to simulate from a normal
distribution instead of a t-distribution.}

\item{omegaLower}{Lower bounds for simulated ETAs (by default -Inf)}

\item{omegaUpper}{Upper bounds for simulated ETAs (by default Inf)}

\item{omegaIsChol}{Indicates if the \code{omega} supplied is a
Cholesky decomposed matrix instead of the traditional
symmetric matrix.}

\item{omegaSeparation}{Omega separation strategy

Tells the type of separation strategy when
simulating covariance with parameter uncertainty with standard
deviations modeled in the \code{thetaMat} matrix.
\itemize{
\item \code{"lkj"} simulates the correlation matrix from the
\code{rLKJ1} matrix with the distribution parameter \code{eta}
equal to the degrees of freedom \code{nu} by \code{(nu-1)/2}
\item \code{"separation"} simulates from the identity inverse Wishart
covariance matrix with \code{nu} degrees of freedom.  This is then
converted to a covariance matrix and augmented with the modeled
standard deviations.  While computationally more complex than the
\code{"lkj"} prior, it performs better when the covariance matrix
size is greater or equal to 10
\item \code{"auto"} chooses \code{"lkj"} when the dimension of the
matrix is less than 10 and \code{"separation"} when greater
than equal to 10.
}}

\item{omegaXform}{When taking \code{omega} values from the \code{thetaMat}
simulations (using the separation strategy for covariance
simulation), how should the \code{thetaMat} values be turned int
standard deviation values:
\itemize{
\item \code{identity} This is when standard deviation values are
directly modeled by the \code{params} and \code{thetaMat} matrix
\item \code{variance} This is when the \code{params} and \code{thetaMat}
simulates the variance that are directly modeled by the
\code{thetaMat} matrix
\item \code{log} This is when the \code{params} and \code{thetaMat}
simulates \code{log(sd)}
\item \code{nlmixrSqrt} This is when the \code{params} and
\code{thetaMat} simulates the inverse cholesky decomposed matrix
with the \code{x^2} modeled along the diagonal.  This only works
with a diagonal matrix.
\item \code{nlmixrLog} This is when the \code{params} and
\code{thetaMat} simulates the inverse cholesky decomposed matrix
with the \code{exp(x^2)} along the diagonal.  This only works
with a diagonal matrix.
\item \code{nlmixrIdentity} This is when the \code{params} and
\code{thetaMat} simulates the inverse cholesky decomposed matrix.
This only works with a diagonal matrix.
}}

\item{nSub}{Number between subject variabilities (\code{ETAs}) simulated for every
realization of the parameters.}

\item{thetaMat}{Named theta matrix.}

\item{thetaLower}{Lower bounds for simulated population parameter
variability (by default \code{-Inf})}

\item{thetaUpper}{Upper bounds for simulated population unexplained
variability (by default \code{Inf})}

\item{thetaDf}{The degrees of freedom of a t-distribution for
simulation.  By default this is \code{NULL} which is
equivalent to \code{Inf} degrees, or to simulate from a normal
distribution instead of a \code{t}-distribution.}

\item{thetaIsChol}{Indicates if the \code{theta} supplied is a
Cholesky decomposed matrix instead of the traditional
symmetric matrix.}

\item{nStud}{Number virtual studies to characterize uncertainty in estimated
parameters.}

\item{sigma}{Named sigma covariance or Cholesky decomposition of a
covariance matrix.  The names of the columns indicate
parameters that are simulated.  These are simulated for every
observation in the solved system. When \code{sigma} is \code{NA} and you are using it with a
\code{rxode2} ui model, the unexplained variability described by
the \code{sigma} matrix are set to zero.}

\item{sigmaLower}{Lower bounds for simulated unexplained variability (by default -Inf)}

\item{sigmaUpper}{Upper bounds for simulated unexplained variability (by default Inf)}

\item{sigmaDf}{Degrees of freedom of the sigma t-distribution.  By
default it is equivalent to \code{Inf}, or a normal distribution.}

\item{sigmaIsChol}{Boolean indicating if the sigma is in the
Cholesky decomposition instead of a symmetric covariance}

\item{sigmaSeparation}{separation strategy for sigma;

Tells the type of separation strategy when
simulating covariance with parameter uncertainty with standard
deviations modeled in the \code{thetaMat} matrix.
\itemize{
\item \code{"lkj"} simulates the correlation matrix from the
\code{rLKJ1} matrix with the distribution parameter \code{eta}
equal to the degrees of freedom \code{nu} by \code{(nu-1)/2}
\item \code{"separation"} simulates from the identity inverse Wishart
covariance matrix with \code{nu} degrees of freedom.  This is then
converted to a covariance matrix and augmented with the modeled
standard deviations.  While computationally more complex than the
\code{"lkj"} prior, it performs better when the covariance matrix
size is greater or equal to 10
\item \code{"auto"} chooses \code{"lkj"} when the dimension of the
matrix is less than 10 and \code{"separation"} when greater
than equal to 10.
}}

\item{sigmaXform}{When taking \code{sigma} values from the \code{thetaMat}
simulations (using the separation strategy for covariance
simulation), how should the \code{thetaMat} values be turned int
standard deviation values:
\itemize{
\item \code{identity} This is when standard deviation values are
directly modeled by the \code{params} and \code{thetaMat} matrix
\item \code{variance} This is when the \code{params} and \code{thetaMat}
simulates the variance that are directly modeled by the
\code{thetaMat} matrix
\item \code{log} This is when the \code{params} and \code{thetaMat}
simulates \code{log(sd)}
\item \code{nlmixrSqrt} This is when the \code{params} and
\code{thetaMat} simulates the inverse cholesky decomposed matrix
with the \code{x^2} modeled along the diagonal.  This only works
with a diagonal matrix.
\item \code{nlmixrLog} This is when the \code{params} and
\code{thetaMat} simulates the inverse cholesky decomposed matrix
with the \code{exp(x^2)} along the diagonal.  This only works
with a diagonal matrix.
\item \code{nlmixrIdentity} This is when the \code{params} and
\code{thetaMat} simulates the inverse cholesky decomposed matrix.
This only works with a diagonal matrix.
}}

\item{nCoresRV}{Number of cores used for the simulation of the
sigma variables.  By default this is 1. To reproduce the results
you need to run on the same platform with the same number of
cores. This is the reason this is set to be one, regardless of
what the number of cores are used in threaded ODE solving.}

\item{nObs}{Number of observations to simulate (with \code{sigma} matrix)}

\item{dfSub}{Degrees of freedom to sample the between subject variability matrix from the
inverse Wishart distribution (scaled) or scaled inverse chi squared distribution.}

\item{dfObs}{Degrees of freedom to sample the unexplained variability matrix from the
inverse Wishart distribution (scaled) or scaled inverse chi squared distribution.}

\item{simSubjects}{boolean indicated rxode2 should simulate subjects in studies (\code{TRUE},
default) or studies (\code{FALSE})}

\item{simVariability}{determines if the variability is simulated.
When \code{NA} (default) this is determined by the solver.}
}
\value{
a data frame with the simulated subjects
}
\description{
Simulate Parameters from a Theta/Omega specification
}
\author{
Matthew L.Fidler
}
