% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llik.R
\name{llikNorm}
\alias{llikNorm}
\title{Log likelihood for normal distribution}
\usage{
llikNorm(x, mean = 0, sd = 1, full = FALSE)
}
\arguments{
\item{x}{Observation}

\item{mean}{Mean for the likelihood}

\item{sd}{Standard devitation for the likelihood}

\item{full}{Add the data frame showing x, mean, sd as well as the
fx and derivatives}
}
\value{
data frame with \code{fx} for the pdf value of with \code{dMean} and
\code{dSd} that has the derivatives with respect to the parameters at
the observation time-point
}
\description{
Log likelihood for normal distribution
}
\details{
In an \code{rxode2()} model, you can use \code{llikNorm()} but you have to
use all arguments.  You can also get the derivitaves with
\code{llikNormDmean()} and \code{llikNormDsd()}
}
\examples{

llikNorm(0)

llikNorm(seq(-2,2,length.out=10), full=TRUE)

et <- et(-3, 3, length.out=10)
et$mu <- 0
et$sigma <- 1

model <- rxode2({
  fx <- llikNorm(time, mu, sigma)
  dMean <- llikNormDmean(time, mu, sigma)
  dSd <- llikNormDsd(time, mu, sigma)
})

ret <- rxSolve(model, et)
ret
}
\author{
Matthew L. Fidler
}
