% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{etTrans}
\alias{etTrans}
\title{Event translation for rxode2}
\usage{
etTrans(
  inData,
  obj,
  addCmt = FALSE,
  dropUnits = FALSE,
  allTimeVar = FALSE,
  keepDosingOnly = FALSE,
  combineDvid = NULL,
  keep = character(0),
  addlKeepsCov = FALSE,
  addlDropSs = TRUE,
  ssAtDoseTime = TRUE
)
}
\arguments{
\item{inData}{Data frame to translate}

\item{obj}{Model to translate data}

\item{addCmt}{Add compartment to data frame (default \code{FALSE}).}

\item{dropUnits}{Boolean to drop the units (default \code{FALSE}).}

\item{allTimeVar}{Treat all covariates as if they were time-varying}

\item{keepDosingOnly}{keep the individuals who only have dosing records and any
trailing dosing records after the last observation.}

\item{combineDvid}{is a boolean indicating if rxode2 will use \code{DVID} on observation
records to change the \code{cmt} value; Useful for multiple-endpoint nlmixr models.  By default
this is determined by \code{option("rxode2.combine.dvid")} and if the option has not been set,
this is \code{TRUE}. This typically does not affect rxode2 simulations.}

\item{keep}{This is a named vector of items you want to keep in the final rxode2 dataset.
For added rxode2 event records (if seen), last observation carried forward will be used.}

\item{addlKeepsCov}{This determines if the additional dosing items
repeats the dose only (\code{FALSE}) or keeps the covariates at the
record of the dose (\code{TRUE})}

\item{addlDropSs}{When there are steady state doses with an \code{addl}
specification the steady state flag is dropped with repeated
doses (when \code{TRUE}) or retained (when \code{FALSE})}

\item{ssAtDoseTime}{Boolean that when \code{TRUE} back calculates the
steady concentration at the actual time of dose, otherwise when
\code{FALSE} the doses are shifted}
}
\value{
Object for solving in rxode2
}
\description{
Event translation for rxode2
}
\keyword{internal}
