% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/et.R
\name{add.sampling}
\alias{add.sampling}
\title{Add sampling to eventTable}
\usage{
add.sampling(eventTable, time, time.units = NA)
}
\arguments{
\item{eventTable}{An eventTable object. When accessed from object it would be \verb{eventTable$}}

\item{time}{a vector of time values (in \code{time.units}).}

\item{time.units}{an optional string specifying the time
units. Defaults to the units specified when the
\code{EventTable} was initialized.}
}
\value{
eventTable with updated sampling.  (Note the event table
will be updated even if you don't reassign the eventTable)
}
\description{
This adds a dosing event to the event table.  This is provided for
piping syntax through magrittr.  It can also be accessed by
\code{eventTable$add.sampling()}
}
\examples{

\donttest{

library(units)

## These are making the more complex regimens of the rxode2 tutorial

## bid for 5 days
bid <- et(timeUnits="hr") \%>\%
       et(amt=10000,ii=12,until=set_units(5, "days"))

## qd for 5 days
qd <- et(timeUnits="hr") \%>\%
      et(amt=20000,ii=24,until=set_units(5, "days"))

## bid for 5 days followed by qd for 5 days

et <- seq(bid,qd) \%>\% et(seq(0,11*24,length.out=100));


## Now Infusion for 5 days followed by oral for 5 days

##  note you can dose to a named compartment instead of using the compartment number
infusion <- et(timeUnits = "hr") \%>\%
      et(amt=10000, rate=5000, ii=24, until=set_units(5, "days"), cmt="centr")


qd <- et(timeUnits = "hr") \%>\% et(amt=10000, ii=24, until=set_units(5, "days"), cmt="depot")

et <- seq(infusion,qd)


## 2wk-on, 1wk-off

qd <- et(timeUnits = "hr") \%>\% et(amt=10000, ii=24, until=set_units(2, "weeks"), cmt="depot")

et <- seq(qd, set_units(1,"weeks"), qd) \%>\%
     add.sampling(set_units(seq(0, 5.5,by=0.005),weeks))


## You can also repeat the cycle easily with the rep function

qd <-et(timeUnits = "hr") \%>\% et(amt=10000, ii=24, until=set_units(2, "weeks"), cmt="depot")

et <- etRep(qd, times=4, wait=set_units(1,"weeks")) \%>\%
     add.sampling(set_units(seq(0, 12.5,by=0.005),weeks))


}
}
\references{
Wang W, Hallow K, James D (2015). "A Tutorial on rxode2: Simulating
Differential Equation Pharmacometric Models in R." CPT:
Pharmacometrics and Systems Pharmacology, 5(1), 3-10. ISSN 2163-8306,
<URL: https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4728294/>.
}
\seealso{
\code{\link{eventTable}}, \code{\link{add.sampling}},
\code{\link{add.dosing}}, \code{\link{et}},
\code{\link{etRep}}, \code{\link{etRbind}}
}
\author{
Matthew L Fidler, Wenping Wang
}
