% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ryt_search.R
\name{ryt_search}
\alias{ryt_search}
\title{Search channels, playlists or videos on YouTube}
\usage{
ryt_search(part = "snippet", ...)
}
\arguments{
\item{part}{The part parameter specifies a comma-separated list of one or more search resource properties that the API response will include. Set the parameter value to snippet.}

\item{...}{Filters and Optional parameters for resources search. See \href{https://developers.google.com/youtube/v3/docs/search/list#parameters}{list of all allowed params}. You can set params names in came or snake case.}
}
\value{
resources list
}
\description{
Returns a collection of search results that match the query parameters specified in the API request. By default, a search result set identifies matching video, channel, and playlist resources, but you can also configure queries to only retrieve a specific type of resource.
}
\examples{
\dontrun{
# search videos by query
search_res_videos <- ryt_search(
  type            = 'video',
  q               = 'r language tutorial',
  published_after = '2022-03-01T00:00:00Z',
  published_before = '2022-06-01T00:00:00Z',
  max_results     = 10
)

# search playlists by query
search_res_playlists <- ryt_search(
  type             = 'playlist',
  q                = 'r language tutorial',
  published_after  = '2022-03-01T00:00:00Z',
  published_before = '2022-06-01T00:00:00Z',
  max_results      = 50
)

# search channel by query
search_res_channels <- ryt_search(
type             = 'channel',
q                = 'r language tutorial',
published_after  = '2022-03-01T00:00:00Z',
  published_before = '2022-06-01T00:00:00Z',
  max_results      = 50
)

# Search in own videos
search_own_dplyr_videos <- ryt_search(
  type             = 'video',
  for_mine         = TRUE,
  q                = 'dplyr'
)

# Search channels and get title and id
search_chn <-  ryt_search(
   type   = 'channel',
   q      = 'R4marketing',
   fields = 'items(snippet(title,channelId))'
)

# Search videos in the channel by query and channel id
search_channel_dplyr_videos <- ryt_search(
  type       = 'video',
  q          = 'dplyr',
  channel_id = "UCyHC6R3mCCP8bhD9tPbjnzQ"
)
}
}
