% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reorder.R
\name{Reorder}
\alias{Reorder}
\title{Reorder the dimension of an array}
\usage{
Reorder(data, order)
}
\arguments{
\item{data}{An array of which the dimension to be reordered.}

\item{order}{A vector of indices or character strings indicating the new 
order of the dimension.}
}
\value{
An array which has the same values as parameter 'data' but with 
 different dimension order.
}
\description{
Reorder the dimension order of a multi-dimensional array
}
\examples{
 dat1 <- array(c(1:30), dim = c(dat = 1, sdate = 3, ftime = 2, lon = 5))
 print(dim(Reorder(dat1, c(2, 1, 4, 3))))
 print(dim(Reorder(dat1, c('sdate', 'dat', 'lon', 'ftime'))))
 dat2 <- array(c(1:10), dim = c(2, 1, 5))
 print(dim(Reorder(dat2, c(2, 1, 3))))
}
