% Generated by roxygen2 (4.0.2): do not edit by hand
\name{diagnostic.plot}
\alias{diagnostic.plot}
\title{Interactive Diagnostic Plot of Samples and Fixations}
\usage{
diagnostic.plot(samples, fixations)
}
\arguments{
\item{samples}{a data frame containing the raw samples as recorded
by the eye-tracker.  This data frame has to have the following
columns:
\describe{
 \item{time:}{the time at which the sample was recorded}
 \item{x:}{the x-coordinate of the sample}
 \item{y:}{the y-coordinate of the sample}
}
Samples have to be listed in chronological order.  The velocity
calculations assume that the sampling frequency is constant.}

\item{fixations}{a data frame containing the fixations that were
detected in the samples.  This data frame has to have the following
columns:
\describe{
 \item{start:}{the time at which the fixations started}
 \item{end:}{the time at which the fixation ended}
 \item{x:}{the x-coordinate of the fixation}
 \item{y:}{the y-coordinate of the fixation}
}}
}
\value{
A recording of the final plot.  Can be re-plotted using
\code{\link[grDevices]{replayPlot}}.
}
\description{
Shows the raw samples and the detected fixations in an interactive
plot.  This plot can be used to screen the data and to diagnose
problems with the fixation detection.
}
\section{Details}{
 The function will open an interactive plot showing the
samples and fixations.  Red dots represent the x-coordinate and
orange dots the y-coordinate.  The gray vertical lines indicate the
on- and offsets of saccades and horizontal lines the coordinates of
the fixations. Instructions for navigating the plot are displayed
on the console.
}
\examples{
\dontrun{
data(samples)
fixations <- detect.fixations(samples)
diagnostic.plot(samples, fixations)
}
}
\author{
Titus von der Malsburg \email{malsburg@posteo.de}
}
\seealso{
\code{\link{detect.fixations}},
\code{\link{calculate.summary}}
}

