% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj_random_forest.R
\name{projection_rf_CorrectedBias}
\alias{projection_rf_CorrectedBias}
\title{projection_rf_CorrectedBias}
\usage{
projection_rf_CorrectedBias(
  data_model,
  target_column,
  predictor_cols,
  data_proj,
  domain1,
  domain2,
  psu,
  ssu,
  strata,
  weights,
  split_ratio = 0.8,
  metric = "Accuracy"
)
}
\arguments{
\item{data_model}{The training dataset, consisting of auxiliary variables and the target variable.}

\item{target_column}{The name of the target column in the \code{data_model}.}

\item{predictor_cols}{A vector of predictor column names.}

\item{data_proj}{The data for projection (prediction), which needs to be projected using the trained model. It must contain the same auxiliary variables as the \code{data_model}}

\item{domain1}{Domain variables for survey estimation (e.g., "province")}

\item{domain2}{Domain variables for survey estimation (e.g., "regency")}

\item{psu}{Primary sampling units, representing the structure of the sampling frame.}

\item{ssu}{Secondary sampling units, representing the structure of the sampling frame.}

\item{strata}{Stratification variable, ensuring that specific subgroups are represented.}

\item{weights}{Weights used in the for direct estimation from \code{data_model} and indirect estimation from \code{data_proj}.}

\item{split_ratio}{Proportion of data used for training (default is 0.8, meaning 80 percent for training and 20 percent for validation).}

\item{metric}{The metric used for model evaluation (default is Accuracy, other options include "AUC", "F1", etc.).}
}
\value{
A list containing the following elements:
\itemize{
   \item \code{model} The trained Random Forest model.
   \item \code{importance} Feature importance showing which features contributed most to the model’s predictions.
   \item \code{train_accuracy} Accuracy of the model on the training set.
   \item \code{validation_accuracy} Accuracy of the model on the validation set.
   \item \code{validation_performance} Confusion matrix for the validation set, showing performance metrics like accuracy, precision, recall, etc.
   \item \code{data_proj} The projection data with predicted values.
   \item \code{Direct} Direct estimations for Domain 1, including estimated values, variance, and relative standard error.
   \item \code{Domain1_corrected_bias} Bias-corrected estimations for Domain 1, including estimated values, variance, and relative standard error.
   \item \code{Domain2_corrected_bias} Bias-corrected estimations for Domain 2, including estimated values, variance, and relative standard error.
}
}
\description{
This function extends \code{projection_rf} by incorporating **bias correction** for better domain-level estimation.
}
\keyword{internal}
