% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{DHS.survey.meta}
\alias{DHS.survey.meta}
\title{DHS Survey Metadata}
\format{
A data frame with 153 rows and 30 columns:
\describe{
  \item{ReleaseDate}{Date the survey data was released.}
  \item{SurveyId}{Unique ID assigned to each DHS survey.}
  \item{MaxAgeWomen}{Maximum age of surveyed women.}
  \item{FieldworkStart}{Start date of survey fieldwork.}
  \item{MinAgeMen}{Minimum age of surveyed men.}
  \item{ImplementingOrg}{Organization implementing the survey.}
  \item{SurveyCharacteristicIds}{IDs of survey characteristics.}
  \item{SurveyType}{Type of survey (e.g., DHS, AIS, MIS).}
  \item{SurveyYearLabel}{Label describing the survey year.}
  \item{IndicatorData}{Boolean. Whether indicator data is available.}
  \item{MinAgeWomen}{Minimum age of surveyed women.}
  \item{SurveyYear}{Year in which the DHS survey was conducted.}
  \item{FieldworkEnd}{End date of survey fieldwork.}
  \item{DHS_CountryCode}{DHS country code.}
  \item{NumberOfSamplePoints}{Number of sample points in the survey.}
  \item{CountryName}{Name of the country where the survey was conducted.}
  \item{NumberOfWomen}{Number of women surveyed.}
  \item{SubregionName}{Name of the subregion.}
  \item{MaxAgeMen}{Maximum age of surveyed men.}
  \item{SurveyNum}{Survey number assigned by DHS.}
  \item{SurveyStatus}{Status of the survey (e.g., Completed, Ongoing).}
  \item{NumberOfFacilities}{Number of health facilities surveyed.}
  \item{UniverseOfMen}{Population coverage for male respondents.}
  \item{RegionName}{Region name for survey coverage.}
  \item{UniverseOfWomen}{Population coverage for female respondents.}
  \item{Footnotes}{Additional survey notes.}
  \item{PublicationDate}{Date when the survey results were published.}
  \item{NumberofHouseholds}{Number of households surveyed.}
  \item{NumberOfMen}{Number of men surveyed.}
  \item{GPS_avail}{Whether GPS coordinates are available for cluster locations.}
}
}
\usage{
DHS.survey.meta
}
\description{
A dataset containing metadata for DHS surveys supported by the app.
}
\keyword{datasets}
