## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(saeHB.TF.beta)
data("dataBeta")

## -----------------------------------------------------------------------------
model <- betaTF(y~X1+X2,area="codearea",weight="w",iter.mcmc = 10000, burn.in = 3000, iter.update = 5, thin = 10, data=dataBeta)

## -----------------------------------------------------------------------------
model$Est_sub

## -----------------------------------------------------------------------------
model$Est_area

## -----------------------------------------------------------------------------
model$coefficient

## -----------------------------------------------------------------------------
model$area_randeff
model$sub_randeff

## -----------------------------------------------------------------------------
model$refVar

## -----------------------------------------------------------------------------
model$plot

## -----------------------------------------------------------------------------
CV_sub <- (model$Est_sub$SD)/(model$Est_sub$Mean)*100
MSE_sub <- model$Est_sub$SD^2
summary(cbind(CV_sub,MSE_sub))

## -----------------------------------------------------------------------------
CV_area <- (model$Est_area$SD)/(model$Est_area$Mean)*100
MSE_area <- model$Est_area$SD^2
summary(cbind(CV_area,MSE_area))

