% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaTF.R
\name{betaTF}
\alias{betaTF}
\title{Small Area Estimation using Hierarchical Bayes Twofold Subarea Level Model under Beta Distribution}
\usage{
betaTF(
  formula,
  area,
  weight,
  iter.update = 3,
  iter.mcmc = 1000,
  coef = NULL,
  var.coef = NULL,
  thin = 1,
  burn.in = floor(iter.mcmc/2),
  sigma2.u = 1,
  sigma2.v = 1,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{area}{Index that describes the code relating to area in each subarea.This should be defined for aggregation to get area estimator. Index start from 1 until m}

\item{weight}{Vector contain proportion units or proportion of population on each subarea. \eqn{w_{ij}}}

\item{iter.update}{Number of updates perform ( default = \code{3})}

\item{iter.mcmc}{Number of total iterations per chain (default = \code{1000})}

\item{coef}{Vector contains prior initial value of Coefficient of Regression Model for fixed effect with default vector of \code{0} with the length of the number of regression coefficients}

\item{var.coef}{Vector contains prior initial value of variance of Coefficient of Regression Model for fixed effect with default vector of \code{1} with the length of the number of regression coefficients}

\item{thin}{Thinning rate, must be a positive integer}

\item{burn.in}{Number of iterations to discard at the beginning}

\item{sigma2.u}{Number of prior initial value of variance of subarea random effect}

\item{sigma2.v}{Number of prior initial value of variance of area random effect}

\item{data}{The data frame}
}
\value{
This function returns a list with following objects:
\item{Est_sub}{A dataframe contains the values, standard deviation, and quantile of Subarea mean Estimates using Twofold Subarea level model under Hierarchical Bayes method}
\item{Est_area}{A dataframe contains the values, standard deviation, and quantile of Area mean Estimates using Twofold Subarea level model under Hierarchical Bayes method}
\item{area_randeff}{A dataframe contains area random effect}
\item{sub_randeff}{A dataframe contains subarea random effect}
\item{refVar}{A dataframe that contains estimated subarea and area random effect variance \eqn{(\sigma_{u}^{2}} and \eqn{\sigma_{v}^{2})}}
\item{coefficient}{A dataframe that contains the estimated model coefficient \eqn{\beta}}
\item{plot}{Trace, Density, Autocorrelation Function Plot of coefficient}
}
\description{
Function \code{betaTF} used for estimation of subarea and area means simultaneously under Twofold Subarea Level Small Area Estimation Model Using Hierarchical Bayesian Method with Beta distribution
The range of data must be \eqn{0<y<1}.
}
\examples{
fit <- betaTF(y~X1+X2,area="codearea",weight="w",data=dataBeta, iter.mcmc = 500)

}
