% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaemixObject.R
\docType{methods}
\name{plot,SaemixObject-method}
\alias{plot,SaemixObject-method}
\alias{plot.saemix}
\alias{plot,SaemixObject}
\alias{plot}
\title{General plot function from SAEM}
\usage{
\S4method{plot}{SaemixObject}(x, y, ...)
}
\arguments{
\item{x}{an object returned by the \code{\link{saemix}} function}

\item{y}{empty}

\item{\dots}{optional arguments passed to the plots}
}
\value{
None
}
\description{
Several plots (selectable by the type argument) are currently available:
convergence plot, individual plots, predictions versus observations,
distribution plots, VPC, residual plots.
}
\details{
This is the generic plot function for an SaemixObject object, which
implements different graphs related to the algorithm (convergence plots,
likelihood estimation) as well as diagnostic graphs. A description is
provided in the PDF documentation. Arguments such as main, xlab, etc... that
can be given to the generic plot function may be used, and will be
interpreted according to the type of plot that is to be drawn.

A special argument plot.type can be set to determine the type of plot; it
can be one of: 
\describe{ 
\item{data:}{A spaghetti plot of the data,displaying the observed data y 
as a function of the regression variable (time for a PK application)} 
\item{convergence:}{For each parameter in the model, this plot shows the 
evolution of the parameter estimate versus the iteration number} 
\item{likelihood:}{Graph showing the evolution of the
log-likelihood during the estimation by importance sampling}
\item{observations.vs.predictions:}{Plot of the predictions computed with
the population parameters versus the observations (left), and plot of the
predictions computed with the individual parameters versus the observations (right)} 
\item{residuals.scatter:}{Scatterplot of the residuals versus the
predictor (top) and versus predictions (bottom), for weighted residuals
(population residuals, left), individual weighted residuals (middle) and npde (right).} 
\item{residuals.distribution:}{Distribution of the residuals,
plotted as histogram (top) and as a QQ-plot (bottom), for weighted residuals
(population residuals, left), individual weighted residuals (middle) and npde (right).} 
\item{individual.fit:}{Individual fits are obtained using the
individual parameters with the individual covariates}
\item{population.fit:}{Population fits are obtained using the population
parameters with the individual covariates} 
\item{both.fit:}{Individual fits, superposing fits obtained using the population 
parameters with the individual covariates (red) and using the individual parameters 
with the individual covariates (green)} 
\item{marginal.distribution:}{Distribution of
the parameters (conditional on covariates when some are included in the
model). A histogram of individual parameter estimates can be overlayed on
the plot, but it should be noted that the histogram does not make sense when
there are covariates influencing the parameters and a warning will be
displayed} 
\item{random.effects:}{Boxplot of the random effects}
\item{correlations:}{Correlation between the random effects}
\item{parameters.vs.covariates:}{Plots of the estimates of the individual
parameters versus the covariates, using scatterplot for continuous
covariates, boxplot for categorical covariates}
\item{randeff.vs.covariates:}{Plots of the estimates of the random effects
versus the covariates, using scatterplot for continuous covariates, boxplot
for categorical covariates} 
\item{npde:}{Plots 4 graphs to evaluate the shape of the distribution of the 
normalised prediction distribution errors (npde)} 
\item{vpc:}{Visual Predictive Check, with options to include the
prediction intervals around the boundaries of the selected interval as well
as around the median (50th percentile of the simulated data).} 
} 
In addition, the following values for plot.type produce a series of plots:
\describe{ 
\item{reduced:}{ produces the following plots: plot of the data,
convergence plots, plot of the likelihood by importance sampling (if
computed), plots of observations versus predictions. This is the default
behaviour of the plot function applied to an SaemixObject object}
\item{full:}{ produces the following plots: plot of the data, convergence
plots, plot of the likelihood by importance sampling (if computed), plots of
observations versus predictions, scatterplots and distribution of residuals,
VPC, npde, boxplot of the random effects, distribution of the parameters,
correlations between random effects, plots of the relationships between
individually estimated parameters and covariates, plots of the relationships
between individually estimated random effects and covariates}

Each plot can be customised by modifying options, either through a list of
options set by the \code{\link{saemix.plot.setoptions}} function, or on the
fly by passing an option in the call to the plot (see examples). 
}
}
\examples{

data(theo.saemix)

saemix.data<-saemixData(name.data=theo.saemix,header=TRUE,sep=" ",na=NA, 
  name.group=c("Id"),name.predictors=c("Dose","Time"),
  name.response=c("Concentration"),name.covariates=c("Weight","Sex"),
  units=list(x="hr",y="mg/L",covariates=c("kg","-")), name.X="Time")

model1cpt<-function(psi,id,xidep) { 
	  dose<-xidep[,1]
	  tim<-xidep[,2]  
	  ka<-psi[id,1]
	  V<-psi[id,2]
	  CL<-psi[id,3]
	  k<-CL/V
	  ypred<-dose*ka/(V*(ka-k))*(exp(-k*tim)-exp(-ka*tim))
	  return(ypred)
}

saemix.model<-saemixModel(model=model1cpt,
  description="One-compartment model with first-order absorption", 
  psi0=matrix(c(1.,20,0.5,0.1,0,-0.01),ncol=3, byrow=TRUE,
  dimnames=list(NULL, c("ka","V","CL"))),transform.par=c(1,1,1),
  covariate.model=matrix(c(0,1,0,0,0,0),ncol=3,byrow=TRUE),fixed.estim=c(1,1,1),
  covariance.model=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),
  omega.init=matrix(c(1,0,0,0,1,0,0,0,1),ncol=3,byrow=TRUE),error.model="constant")

saemix.options<-list(seed=632545,save=FALSE,save.graphs=FALSE)

# Not run (strict time constraints for CRAN)
# saemix.fit<-saemix(saemix.model,saemix.data,saemix.options)

# Set of default plots
# plot(saemix.fit)

# Data
# plot(saemix.fit,plot.type="data")

# Convergence
# plot(saemix.fit,plot.type="convergence")

# Individual plot for subject 1, smoothed
# plot(saemix.fit,plot.type="individual.fit",ilist=1,smooth=TRUE)

# Individual plot for subject 1 to 12, with ask set to TRUE 
# (the system will pause before a new graph is produced)
# plot(saemix.fit,plot.type="individual.fit",ilist=c(1:12),ask=TRUE)

# Diagnostic plot: observations versus population predictions
# par(mfrow=c(1,1))
# plot(saemix.fit,plot.type="observations.vs.predictions",level=0,new=FALSE)

# LL by Importance Sampling
# plot(saemix.fit,plot.type="likelihood")

# Scatter plot of residuals
# Data will be simulated to compute weighted residuals and npde
# the results shall be silently added to the object saemix.fit
# plot(saemix.fit,plot.type="residuals.scatter")

# Boxplot of random effects
# plot(saemix.fit,plot.type="random.effects")

# Relationships between parameters and covariates
# plot(saemix.fit,plot.type="parameters.vs.covariates")

# Relationships between parameters and covariates, on the same page
# par(mfrow=c(3,2))
# plot(saemix.fit,plot.type="parameters.vs.covariates",new=FALSE)

# VPC
# Not run (time constraints for CRAN)
# plot(saemix.fit,plot.type="vpc")

}
\references{
Comets  E, Lavenu A, Lavielle M. Parameter estimation in nonlinear mixed effect models using saemix, an R implementation of the SAEM algorithm. Journal of Statistical Software 80, 3 (2017), 1-41.

Kuhn E, Lavielle M. Maximum likelihood estimation in nonlinear mixed effects models. Computational Statistics and Data Analysis 49, 4 (2005), 1020-1038.

Comets E, Lavenu A, Lavielle M. SAEMIX, an R version of the SAEM algorithm.
20th meeting of the Population Approach Group in Europe, Athens, Greece
(2011), Abstr 2173.
}
\seealso{
\code{\link{SaemixObject}},\code{\link{saemix}},
\code{\link{saemix.plot.setoptions}}, \code{\link{saemix.plot.select}},
\code{\link{saemix.plot.data}}
}
\author{
Emmanuelle Comets <emmanuelle.comets@inserm.fr>, Audrey Lavenu,
Marc Lavielle.
}
\keyword{plot}
