% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.R
\name{decrypt_object}
\alias{decrypt_object}
\title{Decrypt an encrypted R object}
\usage{
decrypt_object(encryptedObject, key = "pass", method = "symmetric")
}
\arguments{
\item{encryptedObject}{A raw object or a string to be decrypted}

\item{key}{A string without embbeded NULL. Default is 'pass'.}

\item{method}{Currently, a stub. It should be 'symmetric'(default)}
}
\value{
A R object
}
\description{
\code{encrypt_object} encrypts a R object as a raw object or a
  string and \code{decrypt_object} decrypts a raw object or a
  string(encrypted by \code{encrypt_object})
}
\examples{
temp <- encrypt_object(1:3)
all(
  is.raw(temp)
  , decrypt_object(temp) == 1:3)

temp <- encrypt_object(iris, ascii = TRUE)
all(
  is.character(temp)
  , decrypt_object(temp) == iris
  , identical(decrypt_object(temp), iris))
rm(temp)

}
