% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{save_object}
\alias{save_object}
\alias{save2}
\title{Save a R object to a connection}
\usage{
save_object(object, conn, ascii = FALSE, key = "pass",
  method = "symmetric")
}
\arguments{
\item{object}{A R object to be encrypted}

\item{conn}{A connection or a file where the encrypted content is written. If
\code{ascii} is TRUE, an encrypted text is written to the connection. Else,
when \code{ascii} is FALSE(default), a raw object is written to the
connection}

\item{ascii}{TRUE, if the encrypted output is a string(written to the text
connection). FALSE, if the encrypted output is a raw object(written to the
raw connection)}

\item{key}{A string without embbeded NULL. Default is 'pass'}

\item{method}{Currently, a stub. It should be 'symmetric'(default)}
}
\value{
An invisible TRUE
}
\description{
\code{save_object} encrypts a R object to raw or text connection
  or a file. \code{retrieve_object} decrypts a raw or a text connection or a
  file (encrypted by \code{save_object}). Note that \code{retrieve_object}
  returns the object.
}
\examples{
all(
  save_object(iris, conn = "iris_safer.bin")
  , identical(retrieve_object(conn = "iris_safer.bin"), iris)
  , unlink("iris_safer.bin") == 0
)

all(
  save_object(iris, conn = "iris_safer_2.txt", ascii = TRUE)
  , identical(retrieve_object(conn = "iris_safer_2.txt", ascii = TRUE), iris)
  , unlink("iris_safer_2.txt") == 0
)

}
