% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{sf_auth}
\alias{sf_auth}
\title{Log in to Salesforce}
\usage{
sf_auth(username = NULL, password = NULL, security_token = NULL,
  login_url = getOption("salesforcer.login_url"), token = NULL,
  consumer_key = getOption("salesforcer.consumer_key"),
  consumer_secret = getOption("salesforcer.consumer_secret"),
  callback_url = getOption("salesforcer.callback_url"),
  cache = getOption("salesforcer.httr_oauth_cache"), verbose = FALSE)
}
\arguments{
\item{username}{Salesforce username, typically an email address}

\item{password}{Salesforce password}

\item{security_token}{Salesforce security token. Note: A new security token is 
generated whenever your password is changed.}

\item{login_url}{a custom login url; defaults to https://login.salesforce.com}

\item{token}{optional; an actual token object or the path to a valid token
stored as an \code{.rds} file}

\item{consumer_key, consumer_secret, callback_url}{the "Consumer Key","Consumer Secret", 
and "Callback URL" when using a connected app; defaults to the \code{salesforcer} 
connected apps' consumer key, secret, and callback url}

\item{cache}{logical or character; TRUE means to cache using the default cache 
file \code{.httr-oauth-salesforcer}, FALSE means don't cache. A string means use 
the specified path as the cache file.}

\item{verbose}{logical; do you want informative messages?}
}
\description{
Log in using Basic (Username-Password) or OAuth 2.0 authenticaion. OAuth does
not require sharing passwords, but will require authorizing \code{salesforcer} 
as a connected app to view and manage your organization. You will be directed to 
a web browser, asked to sign in to your Salesforce account, and to grant \code{salesforcer} 
permission to operate on your behalf. By default, these user credentials are 
cached in a file named \code{.httr-oauth-salesforcer} in the current working directory.
}
\examples{
\dontrun{
# log in using basic authentication (username-password)
sf_auth(username = "test@gmail.com", 
        password = "test_password", 
        security_token = "test_token")

# log in using OAuth 2.0
# Via brower or refresh of .httr-oauth-salesforcer
sf_auth()

# Save token and log in using it
saveRDS(.state$token, "token.rds")
sf_auth(token = "token.rds")
}
}
