% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename-metadata.R
\name{sf_rename_metadata}
\alias{sf_rename_metadata}
\title{Rename Metadata Elements in Salesforce}
\usage{
sf_rename_metadata(metadata_type, old_fullname, new_fullname, verbose = FALSE)
}
\arguments{
\item{metadata_type}{\code{character}; string on what type of metadata to create.}

\item{old_fullname}{\code{character}; string corresponding to the fullName of the element you would
like to rename}

\item{new_fullname}{\code{character}; string corresponding to the new fullName you would like
to apply the targeted element}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
A \code{data.frame} containing the creation result for each submitted metadata component
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#experimental'><img src='figures/lifecycle-experimental.svg' alt='Experimental lifecycle'></a>}}{\strong{Experimental}}

This function takes an old and new name for a
metadata element in Salesforce and applies the new name
}
\examples{
\dontrun{
renamed_custom_object <- sf_rename_metadata(metadata_type = 'CustomObject', 
                                            old_fullname = 'Custom_Account32__c', 
                                            new_fullname = 'Custom_Account99__c')
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/}
}
